/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.InternalGemFireError;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.PartitionedRegionException;

public class RemoteOperationException
extends DataLocationException {
    private static final long serialVersionUID = -595988965679204903L;
    private boolean hasHash = false;
    private int keyHash = 0;

    public void setHash(int h) {
        Assert.assertTrue(!this.hasHash, "setHash already called");
        this.hasHash = true;
        this.keyHash = h;
    }

    public boolean hasHash() {
        return this.hasHash;
    }

    public int getHash() {
        if (!this.hasHash) {
            throw new InternalGemFireError("getHash when no hash");
        }
        return this.keyHash;
    }

    public void checkKey(Object key) throws PartitionedRegionException {
        if (!this.hasHash) {
            return;
        }
        if (key == null) {
            return;
        }
        int expected = key.hashCode();
        if (expected == this.keyHash) {
            return;
        }
        throw new PartitionedRegionException("Object hashCode inconsistent between cache peers. Here = " + expected + "; peer calculated = " + this.keyHash);
    }

    public RemoteOperationException(String message, Throwable cause) {
        super(message, cause);
    }

    public RemoteOperationException(String message) {
        super(message);
    }

    @Override
    public String toString() {
        String result = super.toString();
        if (this.hasHash()) {
            result = result + " (hash = " + this.keyHash + ")";
        }
        return result;
    }
}

