/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.RemoteDestroyMessage;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.RemoteOperationMessage;
import org.apache.geode.internal.cache.versions.DiskVersionTag;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class RemoteInvalidateMessage
extends RemoteDestroyMessage {
    private static final Logger logger = LogService.getLogger();

    public RemoteInvalidateMessage() {
    }

    private RemoteInvalidateMessage(Set recipients, String regionPath, DirectReplyProcessor processor, EntryEventImpl event, boolean useOriginRemote, boolean possibleDuplicate) {
        super(recipients, regionPath, processor, event, null, 78, useOriginRemote, possibleDuplicate);
    }

    public static boolean distribute(EntryEventImpl event, boolean onlyPersistent) {
        Collection<InternalDistributedMember> replicates;
        boolean successful = false;
        DistributedRegion r = (DistributedRegion)event.getRegion();
        Set<InternalDistributedMember> set = replicates = onlyPersistent ? r.getCacheDistributionAdvisor().adviseInitializedPersistentMembers().keySet() : r.getCacheDistributionAdvisor().adviseInitializedReplicates();
        if (replicates.isEmpty()) {
            return false;
        }
        if (replicates.size() > 1) {
            ArrayList<InternalDistributedMember> l = new ArrayList<InternalDistributedMember>(replicates);
            Collections.shuffle(l);
            replicates = l;
        }
        int attempts = 0;
        for (InternalDistributedMember replicate : replicates) {
            try {
                boolean posDup = ++attempts > 1;
                InvalidateResponse processor = RemoteInvalidateMessage.send(replicate, event.getRegion(), event, 74, false, posDup);
                processor.waitForCacheException();
                VersionTag versionTag = processor.getVersionTag();
                if (versionTag != null) {
                    event.setVersionTag(versionTag);
                    if (event.getRegion().getVersionVector() != null) {
                        event.getRegion().getVersionVector().recordVersion(versionTag.getMemberID(), versionTag);
                    }
                }
                event.setInhibitDistribution(true);
                return true;
            }
            catch (TransactionDataNotColocatedException enfe) {
                throw enfe;
            }
            catch (CancelException e) {
                event.getRegion().getCancelCriterion().checkCancelInProgress(e);
            }
            catch (EntryNotFoundException e) {
                throw new EntryNotFoundException("" + event.getKey());
            }
            catch (CacheException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RemoteDestroyMessage caught CacheException during distribution", (Throwable)e);
                }
                successful = true;
            }
            catch (RemoteOperationException e) {
                if (!logger.isTraceEnabled(LogMarker.DM)) continue;
                logger.trace(LogMarker.DM, "RemoteDestroyMessage caught an unexpected exception during distribution", (Throwable)e);
            }
        }
        return successful;
    }

    public static InvalidateResponse send(DistributedMember recipient, LocalRegion r, EntryEventImpl event, int processorType, boolean useOriginRemote, boolean possibleDuplicate) throws RemoteOperationException {
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        InvalidateResponse p = new InvalidateResponse(r.getSystem(), recipients, event.getKey());
        RemoteInvalidateMessage m = new RemoteInvalidateMessage(recipients, r.getFullPath(), p, event, useOriginRemote, possibleDuplicate);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.InvalidateMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws EntryExistsException, RemoteOperationException {
        InternalDistributedMember eventSender = this.originalSender;
        if (eventSender == null) {
            eventSender = this.getSender();
        }
        Object key = this.getKey();
        EntryEventImpl event = EntryEventImpl.create(r, this.getOperation(), key, null, this.getCallbackArg(), this.useOriginRemote, (DistributedMember)eventSender, true, false);
        try {
            if (this.bridgeContext != null) {
                event.setContext(this.bridgeContext);
            }
            event.setCausedByMessage(this);
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
                event.setVersionTag(this.versionTag);
            }
            Assert.assertTrue(this.eventId != null);
            event.setEventId(this.eventId);
            event.setPossibleDuplicate(this.possibleDuplicate);
            boolean eventShouldHaveOldValue = this.getHasOldValue();
            if (eventShouldHaveOldValue) {
                if (this.getOldValueIsSerialized()) {
                    event.setSerializedOldValue(this.getOldValueBytes());
                } else {
                    event.setOldValue(this.getOldValueBytes());
                }
            }
            boolean sendReply = true;
            try {
                r.checkReadiness();
                r.checkForLimitedOrNoAccess();
                r.basicInvalidate(event);
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "remoteInvalidated key: {}", key);
                }
                this.sendReply(this.getSender(), this.processorId, dm, null, event.getRegion(), event.getVersionTag(), startTime);
                sendReply = false;
            }
            catch (EntryNotFoundException eee) {
                if (logger.isDebugEnabled()) {
                    logger.debug("operateOnRegion caught EntryNotFoundException");
                }
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(eee), r, null, startTime);
                sendReply = false;
            }
            catch (PrimaryBucketException pbe) {
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(pbe), r, startTime);
                boolean bl = false;
                event.release();
                return bl;
            }
            boolean bl = sendReply;
            return bl;
        }
        finally {
            event.release();
        }
    }

    RemoteOperationMessage.RemoteOperationResponse createReplyProcessor(PartitionedRegion r, Set recipients, Object key) {
        return new InvalidateResponse(r.getSystem(), recipients, key);
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, LocalRegion r, long startTime) {
        this.sendReply(member, procId, dm, ex, r, null, startTime);
    }

    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, LocalRegion r, VersionTag versionTag, long startTime) {
        InvalidateReplyMessage.send(member, procId, this.getReplySender(dm), versionTag, ex);
    }

    @Override
    public int getDSFID() {
        return -31;
    }

    public static class InvalidateResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile boolean returnValueReceived;
        final Object key;
        VersionTag versionTag;

        public InvalidateResponse(InternalDistributedSystem ds, Set recipients, Object key) {
            super(ds, (Collection)recipients, true);
            this.key = key;
        }

        public void setResponse(VersionTag versionTag) {
            this.returnValueReceived = true;
            this.versionTag = versionTag;
        }

        public void waitForResult() throws CacheException, RemoteOperationException {
            try {
                this.waitForCacheException();
            }
            catch (RemoteOperationException e) {
                e.checkKey(this.key);
                throw e;
            }
            if (!this.returnValueReceived) {
                throw new RemoteOperationException(LocalizedStrings.InvalidateMessage_NO_RESPONSE_CODE_RECEIVED.toLocalizedString());
            }
        }

        public VersionTag getVersionTag() {
            return this.versionTag;
        }
    }

    public static class InvalidateReplyMessage
    extends ReplyMessage {
        private VersionTag versionTag;
        private static final byte HAS_VERSION = 1;
        private static final byte PERSISTENT = 2;

        public InvalidateReplyMessage() {
        }

        private InvalidateReplyMessage(int processorId, VersionTag versionTag, ReplyException ex) {
            this.setProcessorId(processorId);
            this.versionTag = versionTag;
            this.setException(ex);
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender replySender, VersionTag versionTag, ReplyException ex) {
            Assert.assertTrue(recipient != null, "InvalidateReplyMessage NULL reply message");
            InvalidateReplyMessage m = new InvalidateReplyMessage(processorId, versionTag, ex);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "InvalidateReplyMessage process invoking reply processor with processorId:{}", (Object)this.processorId);
            }
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "InvalidateReplyMessage processor not found");
                }
                return;
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
            }
            if (rp instanceof InvalidateResponse) {
                InvalidateResponse processor = (InvalidateResponse)rp;
                processor.setResponse(this.versionTag);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", (Object)rp, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -30;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            byte b = 0;
            if (this.versionTag != null) {
                b = (byte)(b | 1);
            }
            if (this.versionTag instanceof DiskVersionTag) {
                b = (byte)(b | 2);
            }
            out.writeByte(b);
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            boolean persistentTag;
            super.fromData(in);
            byte b = in.readByte();
            boolean hasTag = (b & 1) != 0;
            boolean bl = persistentTag = (b & 2) != 0;
            if (hasTag) {
                this.versionTag = VersionTag.create(persistentTag, in);
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("InvalidateReplyMessage ").append("processorid=").append(this.processorId).append(" exception=").append(this.getException());
            if (this.versionTag != null) {
                sb.append("version=").append(this.versionTag);
            }
            return sb.toString();
        }
    }
}

