/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.RegisterDataSerializersOp;
import org.apache.geode.cache.client.internal.RegisterInstantiatorsOp;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PoolManagerImpl {
    private static final Logger logger = LogService.getLogger();
    private static final PoolManagerImpl impl = new PoolManagerImpl(true);
    private volatile Map<String, Pool> pools = Collections.emptyMap();
    private volatile Iterator<Map.Entry<String, Pool>> itrForEmergencyClose = null;
    private final Object poolLock = new Object();
    private final boolean normalManager;

    public static PoolManagerImpl getPMI() {
        PoolManagerImpl result = CacheCreation.getCurrentPoolManager();
        if (result == null) {
            result = impl;
        }
        return result;
    }

    public PoolManagerImpl(boolean addListener) {
        this.normalManager = addListener;
    }

    public boolean isNormal() {
        return this.normalManager;
    }

    public PoolFactory createFactory() {
        return new PoolFactoryImpl(this);
    }

    public Pool find(String name) {
        return this.pools.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean keepAlive) {
        boolean foundClientPool = false;
        Object object = this.poolLock;
        synchronized (object) {
            for (Map.Entry<String, Pool> entry : this.pools.entrySet()) {
                PoolImpl pool = (PoolImpl)entry.getValue();
                pool.basicDestroy(keepAlive);
                foundClientPool = true;
            }
            this.pools = Collections.emptyMap();
            this.itrForEmergencyClose = null;
            if (foundClientPool) {
                ServerConnection.emptyCommBufferPool();
            }
        }
    }

    public Map<String, Pool> getMap() {
        return new HashMap<String, Pool>(this.pools);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Pool pool) {
        Object object = this.poolLock;
        synchronized (object) {
            HashMap<String, Pool> copy = new HashMap<String, Pool>(this.pools);
            String name = pool.getName();
            Pool old = copy.put(name, pool);
            if (old != null) {
                throw new IllegalStateException(LocalizedStrings.PoolManagerImpl_POOL_NAMED_0_ALREADY_EXISTS.toLocalizedString(name));
            }
            this.pools = Collections.unmodifiableMap(copy);
            this.itrForEmergencyClose = copy.entrySet().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(Pool pool) {
        Object object = this.poolLock;
        synchronized (object) {
            HashMap<String, Pool> copy = new HashMap<String, Pool>(this.pools);
            String name = pool.getName();
            Object rmPool = copy.remove(name);
            if (rmPool == null || rmPool != pool) {
                return false;
            }
            this.pools = Collections.unmodifiableMap(copy);
            this.itrForEmergencyClose = copy.entrySet().iterator();
            return true;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(super.toString()).append("-").append(this.normalManager ? "normal" : "xml");
        return result.toString();
    }

    public static void readyForEvents(InternalDistributedSystem system, boolean xmlPoolsOnly) {
        boolean foundDurablePool = false;
        Map<String, Pool> pools = PoolManager.getAll();
        for (PoolImpl poolImpl : pools.values()) {
            if (!poolImpl.isDurableClient()) continue;
            foundDurablePool = true;
            if (xmlPoolsOnly && !poolImpl.getDeclaredInXML()) continue;
            poolImpl.readyForEvents(system);
        }
        if (pools.size() > 0 && !foundDurablePool) {
            throw new IllegalStateException(LocalizedStrings.PoolManagerImpl_ONLY_DURABLE_CLIENTS_SHOULD_CALL_READYFOREVENTS.toLocalizedString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allPoolsRegisterInstantiator(Instantiator instantiator) {
        Instantiator[] instantiators = new Instantiator[]{instantiator};
        for (PoolImpl poolImpl : PoolManager.getAll().values()) {
            try {
                EventID eventId = InternalInstantiator.generateEventId();
                if (eventId == null) continue;
                RegisterInstantiatorsOp.execute((ExecutablePool)poolImpl, instantiators, InternalInstantiator.generateEventId());
            }
            catch (RuntimeException e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PoolmanagerImpl_ERROR_REGISTERING_INSTANTIATOR_ON_POOL), (Throwable)e);
            }
            finally {
                poolImpl.releaseThreadLocalConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allPoolsRegisterInstantiator(InternalInstantiator.InstantiatorAttributesHolder holder) {
        Object[] holders = new InternalInstantiator.InstantiatorAttributesHolder[]{holder};
        for (PoolImpl poolImpl : PoolManager.getAll().values()) {
            try {
                EventID eventId = InternalInstantiator.generateEventId();
                if (eventId == null) continue;
                RegisterInstantiatorsOp.execute((ExecutablePool)poolImpl, holders, InternalInstantiator.generateEventId());
            }
            catch (RuntimeException e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PoolmanagerImpl_ERROR_REGISTERING_INSTANTIATOR_ON_POOL), (Throwable)e);
            }
            finally {
                poolImpl.releaseThreadLocalConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allPoolsRegisterDataSerializers(DataSerializer dataSerializer) {
        DataSerializer[] dataSerializers = new DataSerializer[]{dataSerializer};
        for (PoolImpl poolImpl : PoolManager.getAll().values()) {
            try {
                EventID eventId = (EventID)dataSerializer.getEventId();
                if (eventId == null) {
                    eventId = InternalDataSerializer.generateEventId();
                }
                if (eventId == null) continue;
                RegisterDataSerializersOp.execute((ExecutablePool)poolImpl, dataSerializers, eventId);
            }
            catch (RuntimeException e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PoolmanagerImpl_ERROR_REGISTERING_INSTANTIATOR_ON_POOL), (Throwable)e);
            }
            finally {
                poolImpl.releaseThreadLocalConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allPoolsRegisterDataSerializers(InternalDataSerializer.SerializerAttributesHolder holder) {
        InternalDataSerializer.SerializerAttributesHolder[] holders = new InternalDataSerializer.SerializerAttributesHolder[]{holder};
        for (PoolImpl poolImpl : PoolManager.getAll().values()) {
            try {
                EventID eventId = holder.getEventId();
                if (eventId == null) {
                    eventId = InternalDataSerializer.generateEventId();
                }
                if (eventId == null) continue;
                RegisterDataSerializersOp.execute((ExecutablePool)poolImpl, holders, eventId);
            }
            catch (RuntimeException e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PoolmanagerImpl_ERROR_REGISTERING_INSTANTIATOR_ON_POOL), (Throwable)e);
            }
            finally {
                poolImpl.releaseThreadLocalConnection();
            }
        }
    }

    public static void emergencyClose() {
        if (impl == null) {
            return;
        }
        Iterator<Map.Entry<String, Pool>> itr = PoolManagerImpl.impl.itrForEmergencyClose;
        if (itr == null) {
            return;
        }
        while (itr.hasNext()) {
            Map.Entry<String, Pool> next = itr.next();
            ((PoolImpl)next.getValue()).emergencyClose();
        }
    }

    public static void loadEmergencyClasses() {
        PoolImpl.loadEmergencyClasses();
    }

    public Pool find(Region<?, ?> region) {
        return this.find(region.getAttributes().getPoolName());
    }
}

