/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DuplicatePrimaryPartitionException;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.FixedPartitionAttributes;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.Node;
import org.apache.geode.internal.cache.PartitionAttributesImpl;
import org.apache.geode.internal.cache.PartitionRegionConfig;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PartitionRegionConfigValidator {
    private static final Logger logger = LogService.getLogger();
    private final PartitionedRegion pr;
    public static final String EVICTION_ATTRIBUTE_MAXIMUM_MEMORY_MESSAGE = " the Eviction Attribute for maximum memory, ";
    public static final String EVICTION_ATTRIBUTE_MAXIMUM_ENTRIES_MESSAGE = " the Eviction Attribute for maximum entries, ";
    public static final String EVICTION_ATTRIBUTES_ARE_INCOMPATIBLE_MESSAGE = " is incompatible with other VMs which have EvictionAttributes ";

    public PartitionRegionConfigValidator(PartitionedRegion pr) {
        this.pr = pr;
    }

    void validatePartitionAttrsFromPRConfig(PartitionRegionConfig prconf) {
        PartitionAttributes prconfPA = prconf.getPartitionAttrs();
        PartitionAttributes userPA = this.pr.getAttributes().getPartitionAttributes();
        if (userPA.getTotalSize() != prconfPA.getTotalSize()) {
            throw new IllegalStateException(LocalizedStrings.PartitionedRegion_TOTAL_SIZE_IN_PARTITIONATTRIBUTES_IS_INCOMPATIBLE_WITH_GLOBALLY_SET_TOTAL_SIZE_SET_THE_TOTAL_SIZE_TO_0MB.toLocalizedString(prconfPA.getTotalSize()));
        }
        if (userPA.getRedundantCopies() != prconfPA.getRedundantCopies()) {
            throw new IllegalStateException(LocalizedStrings.PartitionedRegion_REQUESTED_REDUNDANCY_0_IS_INCOMPATIBLE_WITH_EXISTING_REDUNDANCY_1.toLocalizedString(userPA.getRedundantCopies(), prconfPA.getRedundantCopies()));
        }
        if (prconf.isFirstDataStoreCreated() && this.pr.isDataStore()) {
            this.validateDistributedEvictionAttributes(prconf.getEvictionAttributes());
        }
        Scope prconfScope = prconf.getScope();
        Scope myScope = this.pr.getScope();
        if (!myScope.equals(prconfScope)) {
            throw new IllegalStateException(LocalizedStrings.PartitionedRegion_SCOPE_IN_PARTITIONATTRIBUTES_IS_INCOMPATIBLE_WITH_ALREADY_SET_SCOPESET_THE_SCOPE_TO_0.toLocalizedString(prconfScope));
        }
        int prconfTotalNumBuckets = prconfPA.getTotalNumBuckets();
        if (userPA.getTotalNumBuckets() != prconfTotalNumBuckets) {
            throw new IllegalStateException(LocalizedStrings.PartitionedRegion_THE_TOTAL_NUMBER_OF_BUCKETS_FOUND_IN_PARTITIONATTRIBUTES_0_IS_INCOMPATIBLE_WITH_THE_TOTAL_NUMBER_OF_BUCKETS_USED_BY_OTHER_DISTRIBUTED_MEMBERS_SET_THE_NUMBER_OF_BUCKETS_TO_1.toLocalizedString(userPA.getTotalNumBuckets(), prconfTotalNumBuckets));
        }
        this.validatePartitionListeners(prconf, userPA);
        this.validatePartitionResolver(prconf, userPA);
        this.validateColocatedWith(prconf, userPA);
        this.validateExpirationAttributes(this.pr.getAttributes(), prconf);
    }

    private void validatePartitionListeners(PartitionRegionConfig prconf, PartitionAttributes userPA) {
        ArrayList<String> prconfList = prconf.getPartitionListenerClassNames();
        if (userPA.getPartitionListeners() == null && userPA.getPartitionListeners().length == 0 && prconfList != null) {
            throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_INCOMPATIBLE_PARTITION_LISTENER.toLocalizedString(null, prconfList));
        }
        if (userPA.getPartitionListeners() != null && prconfList != null) {
            ArrayList<String> userPRList = new ArrayList<String>();
            for (int i = 0; i < userPA.getPartitionListeners().length; ++i) {
                userPRList.add(userPA.getPartitionListeners()[i].getClass().getName());
            }
            if (userPA.getPartitionListeners().length != prconfList.size()) {
                throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_INCOMPATIBLE_PARTITION_LISTENER.toLocalizedString(userPRList, prconfList));
            }
            for (String listener : prconfList) {
                if (userPRList.contains(listener)) continue;
                throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_INCOMPATIBLE_PARTITION_LISTENER.toLocalizedString(userPRList, prconfList));
            }
        }
    }

    private void validatePartitionResolver(PartitionRegionConfig prconf, PartitionAttributes userPA) {
        if (userPA.getPartitionResolver() != null && prconf.getResolverClassName() != null && !prconf.getResolverClassName().equals(userPA.getPartitionResolver().getClass().getName())) {
            throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_INCOMPATIBLE_PARTITION_RESOLVER.toLocalizedString(userPA.getPartitionResolver().getClass().getName(), prconf.getResolverClassName()));
        }
    }

    private void validateColocatedWith(PartitionRegionConfig prconf, PartitionAttributes userPA) {
        if (userPA.getColocatedWith() == null && prconf.getColocatedWith() != null) {
            throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_INCOMPATIBLE_COLOCATED_WITH.toLocalizedString("null", prconf.getColocatedWith()));
        }
        if (userPA.getColocatedWith() != null && prconf.getColocatedWith() != null && !prconf.getColocatedWith().equals(userPA.getColocatedWith())) {
            throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_INCOMPATIBLE_COLOCATED_WITH.toLocalizedString(userPA.getColocatedWith(), prconf.getColocatedWith()));
        }
    }

    private void validateExpirationAttributes(RegionAttributes userRA, PartitionRegionConfig prconf) {
        if (!userRA.getRegionIdleTimeout().equals(prconf.getRegionIdleTimeout())) {
            throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_INCOMPATIBLE_EXPIRATION_ATTRIBUETS.toLocalizedString(" region idle timout "));
        }
        if (!userRA.getRegionTimeToLive().equals(prconf.getRegionTimeToLive())) {
            throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_INCOMPATIBLE_EXPIRATION_ATTRIBUETS.toLocalizedString(" region time to live "));
        }
        if (!userRA.getEntryIdleTimeout().equals(prconf.getEntryIdleTimeout())) {
            throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_INCOMPATIBLE_EXPIRATION_ATTRIBUETS.toLocalizedString(" entry idle timout "));
        }
        if (!userRA.getEntryTimeToLive().equals(prconf.getEntryTimeToLive())) {
            throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_INCOMPATIBLE_EXPIRATION_ATTRIBUETS.toLocalizedString(" entry time to live "));
        }
    }

    private void validateDistributedEvictionAttributes(EvictionAttributes prconfEa) {
        boolean equivAlgoAndAction;
        EvictionAttributes ea = this.pr.getAttributes().getEvictionAttributes();
        Assert.assertTrue(ea != null);
        Assert.assertTrue(prconfEa != null);
        boolean bl = equivAlgoAndAction = ea.getAlgorithm().equals(prconfEa.getAlgorithm()) && ea.getAction().equals(prconfEa.getAction());
        if (!equivAlgoAndAction) {
            throw new IllegalStateException("For Partitioned Region " + this.pr.getFullPath() + " the configured EvictionAttributes " + ea + EVICTION_ATTRIBUTES_ARE_INCOMPATIBLE_MESSAGE + prconfEa);
        }
        if (ea.getAction().isLocalDestroy() && !ea.getAlgorithm().isLRUHeap() && ea.getMaximum() != prconfEa.getMaximum()) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_0_EVICTIONATTRIBUTES_1_DO_NOT_MATCH_WITH_OTHER_2, new Object[]{this.pr.getFullPath(), ea, prconfEa}));
        }
    }

    void validateEvictionAttributesAgainstLocalMaxMemory() {
        EvictionAttributes ea = this.pr.getEvictionAttributes();
        if (this.pr.getLocalMaxMemory() == 0 && !ea.getAction().isNone()) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegion_EVICTIONATTRIBUTES_0_WILL_HAVE_NO_EFFECT_1_2, new Object[]{ea, this.pr.getFullPath(), this.pr.localMaxMemory}));
        }
    }

    void validatePersistentMatchBetweenDataStores(PartitionRegionConfig prconf) {
        boolean isPersistent;
        boolean bl = isPersistent = this.pr.getAttributes().getDataPolicy() == DataPolicy.PERSISTENT_PARTITION;
        if (this.pr.getLocalMaxMemory() == 0 || prconf == null) {
            return;
        }
        Set<Node> nodes = prconf.getNodes();
        for (Node n : nodes) {
            if (n.getPRType() != 3 || n.isPersistent() == (this.pr.getAttributes().getDataPolicy() == DataPolicy.PERSISTENT_PARTITION)) continue;
            throw new IllegalStateException("DataPolicy for Datastore members should all be persistent or not.");
        }
    }

    void validateColocation() {
        PartitionAttributesImpl userPA = (PartitionAttributesImpl)this.pr.getAttributes().getPartitionAttributes();
        userPA.validateColocation();
        PartitionedRegion colocatedPR = ColocationHelper.getColocatedRegion(this.pr);
        if (colocatedPR != null) {
            if (colocatedPR.getPartitionAttributes().getTotalNumBuckets() != userPA.getTotalNumBuckets()) {
                throw new IllegalStateException("Colocated regions should have same number of total-num-buckets");
            }
            if (colocatedPR.getPartitionAttributes().getRedundantCopies() != userPA.getRedundantCopies()) {
                throw new IllegalStateException("Colocated regions should have same number of redundant-copies");
            }
            if (colocatedPR.getPartitionAttributes().getLocalMaxMemory() == 0 && userPA.getLocalMaxMemory() != 0) {
                throw new IllegalStateException("Colocated regions should have accessors at the same node");
            }
            if (colocatedPR.getLocalMaxMemory() != 0 && userPA.getLocalMaxMemory() == 0) {
                throw new IllegalStateException("Colocated regions should have accessors at the same node");
            }
            if (!this.pr.isShadowPR() && this.pr.getAttributes().getDataPolicy().withPersistence() && !colocatedPR.getDataPolicy().withPersistence()) {
                throw new IllegalStateException("Cannot colocate a persistent region with a non persistent region");
            }
        }
    }

    public void validateCacheLoaderWriterBetweenDataStores(PartitionRegionConfig prconf) {
        if (this.pr.getLocalMaxMemory() == 0 || prconf == null) {
            return;
        }
        Set<Node> nodes = prconf.getNodes();
        for (Node n : nodes) {
            if (n.getPRType() != 3) continue;
            if (n.isCacheLoaderAttached() && this.pr.getAttributes().getCacheLoader() == null) {
                throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_CACHE_LOADER_IS_NOTNULL_IN_PARTITIONED_REGION_0_ON_OTHER_DATASTORE.toLocalizedString(this.pr.getName()));
            }
            if (!n.isCacheLoaderAttached() && this.pr.getAttributes().getCacheLoader() != null) {
                throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_CACHE_LOADER_IS_NULL_IN_PARTITIONED_REGION_0_ON_OTHER_DATASTORE.toLocalizedString(this.pr.getName()));
            }
            if (n.isCacheWriterAttached() && this.pr.getAttributes().getCacheWriter() == null) {
                throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_CACHE_WRITER_IS_NOTNULL_IN_PARTITIONED_REGION_0_ON_OTHER_DATASTORE.toLocalizedString(this.pr.getName()));
            }
            if (n.isCacheWriterAttached() || this.pr.getAttributes().getCacheWriter() == null) continue;
            throw new IllegalStateException(LocalizedStrings.PartitionRegionConfigValidator_CACHE_WRITER_IS_NULL_IN_PARTITIONED_REGION_0_ON_OTHER_DATASTORE.toLocalizedString(this.pr.getName()));
        }
    }

    void validateFixedPartitionAttributes() {
        if (this.pr.getFixedPartitionAttributesImpl() != null) {
            this.validatePrimaryFixedPartitionAttributes();
            this.validateFixedPartitionAttributesAgainstRedundantCopies();
            this.validateFixedPartitionAttributesAgainstTotalNumberBuckets();
        }
    }

    private void validateFixedPartitionAttributesAgainstTotalNumberBuckets() {
        for (FixedPartitionAttributesImpl fpa : this.pr.getFixedPartitionAttributesImpl()) {
            int numBuckets = 0;
            HashSet<FixedPartitionAttributesImpl> allFPAs = new HashSet<FixedPartitionAttributesImpl>(this.pr.getRegionAdvisor().adviseAllFixedPartitionAttributes());
            allFPAs.add(fpa);
            for (FixedPartitionAttributes fixedPartitionAttributes : allFPAs) {
                numBuckets += fixedPartitionAttributes.getNumBuckets();
            }
            if (numBuckets <= this.pr.getTotalNumberOfBuckets()) continue;
            Object[] prms = new Object[]{this.pr.getName(), numBuckets, this.pr.getTotalNumberOfBuckets()};
            throw new IllegalStateException(LocalizedStrings.PartitionedRegionConfigValidator_FOR_REGION_0_SUM_OF_NUM_BUCKETS_1_FOR_DIFFERENT_PRIMARY_PARTITIONS_SHOULD_NOT_BE_GREATER_THAN_TOTAL_NUM_BUCKETS_2.toString(prms));
        }
    }

    private void validateFixedPartitionAttributesAgainstRedundantCopies() {
        for (FixedPartitionAttributesImpl fpa : this.pr.getFixedPartitionAttributesImpl()) {
            List<FixedPartitionAttributesImpl> allSameFPAs = this.pr.getRegionAdvisor().adviseSameFPAs(fpa);
            allSameFPAs.add(fpa);
            if (allSameFPAs.isEmpty()) continue;
            int numSecondaries = 0;
            for (FixedPartitionAttributes fixedPartitionAttributes : allSameFPAs) {
                if (fpa.getNumBuckets() != fixedPartitionAttributes.getNumBuckets()) {
                    Object[] prms = new Object[]{this.pr.getName(), fpa.getPartitionName(), fpa.getNumBuckets(), fixedPartitionAttributes.getNumBuckets()};
                    throw new IllegalStateException(LocalizedStrings.PartitionedRegionConfigValidator_FOR_REGION_0_FOR_PARTITION_1_NUM_BUCKETS_ARE_NOT_SAME_ACROSS_NODES.toString(prms));
                }
                if (fixedPartitionAttributes.isPrimary() || ++numSecondaries <= this.pr.getRedundantCopies()) continue;
                Object[] prms = new Object[]{this.pr.getName(), numSecondaries, fpa.getPartitionName(), this.pr.getRedundantCopies()};
                throw new IllegalStateException(LocalizedStrings.PartitionedRegionConfigValidator_FOR_REGION_0_NUMBER_OF_SECONDARY_PARTITIONS_1_OF_A_PARTITION_2_SHOULD_NEVER_EXCEED_NUMBER_OF_REDUNDANT_COPIES_3.toString(prms));
            }
        }
    }

    private void validatePrimaryFixedPartitionAttributes() {
        List<FixedPartitionAttributesImpl> remotePrimaryFPAs = this.pr.getRegionAdvisor().adviseRemotePrimaryFPAs();
        for (FixedPartitionAttributes fixedPartitionAttributes : this.pr.getFixedPartitionAttributesImpl()) {
            if (!fixedPartitionAttributes.isPrimary() || !remotePrimaryFPAs.contains(fixedPartitionAttributes)) continue;
            Object[] prms = new Object[]{this.pr.getName(), fixedPartitionAttributes.getPartitionName()};
            throw new DuplicatePrimaryPartitionException(LocalizedStrings.PartitionedRegionConfigValidator_FOR_REGION_0_SAME_PARTITION_NAME_1_CANNOT_BE_DEFINED_AS_PRIMARY_ON_MORE_THAN_ONE_NODE.toString(prms));
        }
    }

    public void validateFixedPABetweenDataStores(PartitionRegionConfig prconf) {
        boolean isDataStore = this.pr.localMaxMemory > 0;
        boolean isFixedPR = this.pr.fixedPAttrs != null;
        Set<Node> nodes = prconf.getNodes();
        for (Node n : nodes) {
            if (isFixedPR) {
                if (n.getPRType() != 2 && n.getPRType() != 3) continue;
                Object[] prms = new Object[]{this.pr.getName()};
                throw new IllegalStateException(LocalizedStrings.PartitionedRegionConfigValidator_FIXED_PARTITION_REGION_ONE_DATASTORE_IS_WITHOUTFPA.toLocalizedString(prms));
            }
            if (!isDataStore || n.getPRType() != 4 && n.getPRType() != 5) continue;
            Object[] prms = new Object[]{this.pr.getName()};
            throw new IllegalStateException(LocalizedStrings.PartitionedRegionConfigValidator_FIXED_PARTITION_REGION_ONE_DATASTORE_IS_WITHOUTFPA.toLocalizedString(prms));
        }
    }
}

