/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXMessage;
import org.apache.geode.internal.cache.TXRemoteCommitMessage;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class JtaAfterCompletionMessage
extends TXMessage {
    private static final Logger logger = LogService.getLogger();
    private int status;
    private int processorType;

    public JtaAfterCompletionMessage() {
    }

    @Override
    public int getProcessorType() {
        return this.processorType;
    }

    public JtaAfterCompletionMessage(int status, int txUniqId, InternalDistributedMember onBehalfOfClientMember, ReplyProcessor21 processor) {
        super(txUniqId, onBehalfOfClientMember, processor);
        this.status = status;
    }

    public static TXRemoteCommitMessage.RemoteCommitResponse send(Cache cache, int txId, InternalDistributedMember onBehalfOfClientMember, int status, DistributedMember recipient) {
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        TXRemoteCommitMessage.RemoteCommitResponse response = new TXRemoteCommitMessage.RemoteCommitResponse(system, recipients);
        JtaAfterCompletionMessage msg = new JtaAfterCompletionMessage(status, txId, onBehalfOfClientMember, response);
        msg.setRecipients(recipients);
        msg.processorType = system.threadOwnsResources() ? 74 : 75;
        system.getDistributionManager().putOutgoing(msg);
        return response;
    }

    @Override
    protected boolean operateOnTx(TXId txId, DistributionManager dm) throws RemoteOperationException {
        TXManagerImpl txMgr = GemFireCacheImpl.getInstance().getTXMgr();
        if (logger.isDebugEnabled()) {
            logger.debug("JTA: Calling afterCompletion for :{}", (Object)txId);
        }
        TXStateProxy txState = txMgr.getTXState();
        txState.setCommitOnBehalfOfRemoteStub(true);
        txState.afterCompletion(this.status);
        TXCommitMessage cmsg = txState.getCommitMessage();
        TXRemoteCommitMessage.TXRemoteCommitReplyMessage.send(this.getSender(), this.getProcessorId(), cmsg, this.getReplySender(dm));
        txMgr.removeHostedTXState(txId);
        return false;
    }

    @Override
    public int getDSFID() {
        return -115;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.status);
        out.writeInt(this.processorType);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.status = in.readInt();
        this.processorType = in.readInt();
    }
}

