/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataInputStream;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.logging.log4j.Logger;

public class EventID
implements DataSerializableFixedID,
Serializable,
Externalizable {
    private static final Logger logger = LogService.getLogger();
    private static boolean LOG_ID_BYTES = Boolean.getBoolean("gemfire.log-event-member-id-bytes");
    private byte[] membershipID;
    private long threadID;
    private long sequenceID;
    private int bucketID;
    private byte breadcrumbCounter = 0;
    private static final Version[] dsfidVersions = new Version[]{Version.GFE_80};
    private static ThreadLocal threadIDLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new ThreadAndSequenceIDWrapper();
        }
    };
    private transient int hashCode = 0;
    private static volatile DistributedSystem system = null;
    private static DistributedMember systemMemberId;
    private static volatile byte[] client_side_event_identity;
    static AbstractEventIDByteArrayFiller[] fillerArray;
    static final int NULL_90_MEMBER_DATA_LENGTH = 17;
    static final int MINIMIM_ID_LENGTH = 19;

    public void incBreadcrumbCounter() {
        this.breadcrumbCounter = (byte)(this.breadcrumbCounter + 1);
    }

    private EventID(byte[] membershipId) {
        this.membershipID = membershipId;
        ThreadAndSequenceIDWrapper wrapper = (ThreadAndSequenceIDWrapper)threadIDLocal.get();
        this.threadID = wrapper.threadID;
        this.sequenceID = wrapper.getAndIncrementSequenceID();
        this.bucketID = -1;
    }

    public EventID(DistributedSystem sys) {
        this(EventID.initializeAndGetDSEventIdentity(sys));
    }

    public static byte[] getMembershipId(DistributedSystem sys) {
        return EventID.initializeAndGetDSEventIdentity(sys);
    }

    public static void unsetDS() {
        system = null;
    }

    public static byte[] getMembershipId(ClientProxyMembershipID client) {
        try {
            HeapDataOutputStream hdos = new HeapDataOutputStream(256, client.getClientVersion());
            ((InternalDistributedMember)client.getDistributedMember()).writeEssentialData(hdos);
            return hdos.toByteArray();
        }
        catch (IOException ioe) {
            throw new InternalGemFireException(LocalizedStrings.ClientProxyMembershipID_UNABLE_TO_SERIALIZE_IDENTITY.toLocalizedString(), ioe);
        }
    }

    public static long getThreadId() {
        ThreadAndSequenceIDWrapper wrapper = (ThreadAndSequenceIDWrapper)threadIDLocal.get();
        return wrapper.threadID;
    }

    public static long getSequenceId() {
        ThreadAndSequenceIDWrapper wrapper = (ThreadAndSequenceIDWrapper)threadIDLocal.get();
        return wrapper.sequenceID;
    }

    public static long reserveSequenceId() {
        ThreadAndSequenceIDWrapper wrapper = (ThreadAndSequenceIDWrapper)threadIDLocal.get();
        return wrapper.getAndIncrementSequenceID();
    }

    public void reserveSequenceId(int count) {
        ThreadAndSequenceIDWrapper wrapper = (ThreadAndSequenceIDWrapper)threadIDLocal.get();
        wrapper.reserveSequenceID(count);
    }

    public EventID(EventID eventId, int offset) {
        assert (eventId != null);
        this.membershipID = eventId.getMembershipID();
        this.threadID = eventId.getThreadID();
        this.sequenceID = eventId.getSequenceID() + (long)offset;
        this.bucketID = -1;
    }

    public EventID(byte[] memId, long threadId, long seqId) {
        this.membershipID = memId;
        this.threadID = threadId;
        this.sequenceID = seqId;
        this.bucketID = -1;
    }

    public EventID(byte[] memId, long threadId, long seqId, int bucketId) {
        this.membershipID = memId;
        this.threadID = threadId;
        this.sequenceID = seqId;
        this.bucketID = bucketId;
    }

    public static Object getThreadLocalDataForHydra() {
        Object result = threadIDLocal.get();
        threadIDLocal.set(null);
        return result;
    }

    public static void setThreadLocalDataForHydra(Object wrapper) {
        if (!(wrapper instanceof ThreadAndSequenceIDWrapper)) {
            throw new IllegalArgumentException("Expected a ThreadAndSequenceIdWrapper but received " + wrapper);
        }
        threadIDLocal.set(wrapper);
    }

    public EventID() {
    }

    public long getThreadID() {
        return this.threadID;
    }

    public void setThreadID(long threadID) {
        this.threadID = threadID;
    }

    public byte[] getMembershipID() {
        return this.membershipID;
    }

    public int getBucketID() {
        return this.bucketID;
    }

    public InternalDistributedMember getDistributedMember() {
        return this.getDistributedMember(Version.CURRENT);
    }

    public InternalDistributedMember getDistributedMember(Version targetVersion) {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.membershipID);
        DataInputStream dis = new DataInputStream(bais);
        if (targetVersion.compareTo(Version.GEODE_110) < 0) {
            dis = new VersionedDataInputStream(dis, Version.GFE_90);
        }
        InternalDistributedMember result = null;
        try {
            result = InternalDistributedMember.readEssentialData(dis);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public long getSequenceID() {
        return this.sequenceID;
    }

    public byte[] calcBytes() {
        return EventID.getOptimizedByteArrayForEventID(this.getThreadID(), this.getSequenceID());
    }

    @Override
    public int getDSFID() {
        return 36;
    }

    @Override
    public void toData(DataOutput dop) throws IOException {
        Version version = InternalDataSerializer.getVersionForDataStream(dop);
        if (version.compareTo(Version.GEODE_110) < 0) {
            InternalDistributedMember member = this.getDistributedMember(Version.GFE_90);
            HeapDataOutputStream hdos = new HeapDataOutputStream(Version.GFE_90);
            member.writeEssentialData(hdos);
            DataSerializer.writeByteArray(hdos.toByteArray(), dop);
        } else {
            DataSerializer.writeByteArray(this.membershipID, dop);
        }
        DataSerializer.writeByteArray(EventID.getOptimizedByteArrayForEventID(this.threadID, this.sequenceID), dop);
        dop.writeInt(this.bucketID);
        dop.writeByte(this.breadcrumbCounter);
    }

    public void toDataPre_GFE_8_0_0_0(DataOutput dop) throws IOException {
        DataSerializer.writeByteArray(this.membershipID, dop);
        DataSerializer.writeByteArray(EventID.getOptimizedByteArrayForEventID(this.threadID, this.sequenceID), dop);
    }

    @Override
    public void fromData(DataInput di) throws IOException, ClassNotFoundException {
        this.membershipID = DataSerializer.readByteArray(di);
        ByteBuffer eventIdParts = ByteBuffer.wrap(DataSerializer.readByteArray(di));
        this.threadID = EventID.readEventIdPartsFromOptmizedByteArray(eventIdParts);
        this.sequenceID = EventID.readEventIdPartsFromOptmizedByteArray(eventIdParts);
        this.bucketID = di.readInt();
        this.breadcrumbCounter = di.readByte();
    }

    public void fromDataPre_GFE_8_0_0_0(DataInput di) throws IOException, ClassNotFoundException {
        this.membershipID = DataSerializer.readByteArray(di);
        ByteBuffer eventIdParts = ByteBuffer.wrap(DataSerializer.readByteArray(di));
        this.threadID = EventID.readEventIdPartsFromOptmizedByteArray(eventIdParts);
        this.sequenceID = EventID.readEventIdPartsFromOptmizedByteArray(eventIdParts);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        DataSerializer.writeByteArray(this.membershipID, out);
        DataSerializer.writeByteArray(EventID.getOptimizedByteArrayForEventID(this.threadID, this.sequenceID), out);
        out.writeInt(this.bucketID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.membershipID = DataSerializer.readByteArray(in);
        ByteBuffer eventIdParts = ByteBuffer.wrap(DataSerializer.readByteArray(in));
        this.threadID = EventID.readEventIdPartsFromOptmizedByteArray(eventIdParts);
        this.sequenceID = EventID.readEventIdPartsFromOptmizedByteArray(eventIdParts);
        this.bucketID = in.readInt();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventID other = (EventID)obj;
        if (this.sequenceID != other.sequenceID) {
            return false;
        }
        if (this.threadID != other.threadID) {
            return false;
        }
        return EventID.equalMembershipIds(this.membershipID, other.membershipID);
    }

    public static boolean equalMembershipIds(byte[] m1, byte[] m2) {
        int sizeDifference = Math.abs(m1.length - m2.length);
        if (sizeDifference != 0 && sizeDifference != 17) {
            return false;
        }
        for (int i = 0; i < m1.length; ++i) {
            if (i >= m2.length) {
                return EventID.nullUUIDCheck(m1, i);
            }
            if (m1[i] == m2[i]) continue;
            return false;
        }
        if (m1.length != m2.length) {
            return EventID.nullUUIDCheck(m2, m1.length);
        }
        return true;
    }

    private static boolean nullUUIDCheck(byte[] memberID, int position) {
        if (position < 0) {
            return false;
        }
        if (memberID.length - position != 17) {
            return false;
        }
        for (int i = position; i < memberID.length; ++i) {
            if (memberID[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static int hashCodeMemberId(byte[] memberID) {
        if (memberID.length < 36 || !EventID.nullUUIDCheck(memberID, memberID.length - 17)) {
            return Arrays.hashCode(memberID);
        }
        byte[] newID = new byte[memberID.length - 17];
        System.arraycopy(memberID, 0, newID, 0, newID.length);
        return Arrays.hashCode(newID);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + EventID.hashCodeMemberId(this.membershipID);
            result = 31 * result + (int)(this.sequenceID ^ this.sequenceID >>> 32);
            this.hashCode = result = 31 * result + (int)(this.threadID ^ this.threadID >>> 32);
        }
        return this.hashCode;
    }

    String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    public String expensiveToString() {
        Object mbr;
        try {
            mbr = InternalDistributedMember.readEssentialData(new DataInputStream(new ByteArrayInputStream(this.membershipID)));
        }
        catch (Exception e) {
            mbr = this.membershipID;
        }
        return "EventID[" + mbr + ";threadID=" + ThreadIdentifier.toDisplayString(this.threadID) + ";sequenceID=" + this.sequenceID + (Breadcrumbs.ENABLED ? ";bcrumb=" + this.breadcrumbCounter : "") + (this.bucketID >= 0 ? ";bucketID=" + this.bucketID : "") + "]";
    }

    public String toString() {
        if (logger.isTraceEnabled(LogMarker.DM_BRIDGE_SERVER)) {
            return this.expensiveToString();
        }
        return this.cheapToString();
    }

    public String cheapToString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getShortClassName());
        if (LOG_ID_BYTES) {
            buf.append("[membershipID=");
            for (int i = 0; i < this.membershipID.length; ++i) {
                buf.append(this.membershipID[i]);
                if (i >= this.membershipID.length - 1) continue;
                buf.append(',');
            }
            buf.append(";");
        } else {
            buf.append("id=").append(this.membershipID.length).append("bytes;");
        }
        buf.append("threadID=");
        buf.append(ThreadIdentifier.toDisplayString(this.threadID));
        buf.append(";sequenceID=");
        buf.append(this.sequenceID);
        if (Breadcrumbs.ENABLED) {
            buf.append(";bcrumb=").append(this.breadcrumbCounter);
        }
        if (this.bucketID >= 0) {
            buf.append(";bucketId=");
            buf.append(this.bucketID);
        }
        buf.append("]");
        return buf.toString();
    }

    private static byte[] initializeAndGetDSEventIdentity(DistributedSystem sys) {
        if (sys == null) {
            throw new IllegalStateException(LocalizedStrings.ClientProxyMembershipID_ATTEMPTING_TO_HANDSHAKE_WITH_CACHESERVER_BEFORE_CREATING_DISTRIBUTEDSYSTEM_AND_CACHE.toLocalizedString());
        }
        if (system != sys) {
            systemMemberId = sys.getDistributedMember();
            try {
                HeapDataOutputStream hdos = new HeapDataOutputStream(256, Version.CURRENT);
                ((InternalDistributedMember)systemMemberId).writeEssentialData(hdos);
                client_side_event_identity = hdos.toByteArray();
            }
            catch (IOException ioe) {
                throw new InternalGemFireException(LocalizedStrings.ClientProxyMembershipID_UNABLE_TO_SERIALIZE_IDENTITY.toLocalizedString(), ioe);
            }
            system = sys;
        }
        return client_side_event_identity;
    }

    public static int getByteSizeForValue(long id) {
        int length = 0;
        length = id <= 127L ? 1 : (id <= 32767L ? 2 : (id <= Integer.MAX_VALUE ? 4 : 8));
        return length;
    }

    public static byte[] getOptimizedByteArrayForEventID(long threadId, long sequenceId) {
        int threadIdLength = EventID.getByteSizeForValue(threadId);
        int threadIdIndex = threadIdLength == 1 ? 0 : threadIdLength / 4 + 1;
        int sequenceIdLength = EventID.getByteSizeForValue(sequenceId);
        int sequenceIdIndex = sequenceIdLength == 1 ? 0 : sequenceIdLength / 4 + 1;
        int byteBufferLength = 2 + threadIdLength + sequenceIdLength;
        ByteBuffer buffer = ByteBuffer.allocate(byteBufferLength);
        fillerArray[threadIdIndex].fill(buffer, threadId);
        fillerArray[sequenceIdIndex].fill(buffer, sequenceId);
        return buffer.array();
    }

    public static long readEventIdPartsFromOptmizedByteArray(ByteBuffer buffer) {
        byte byteType = buffer.get();
        long id = fillerArray[byteType].read(buffer);
        return id;
    }

    @Override
    public Version[] getSerializationVersions() {
        return dsfidVersions;
    }

    static {
        client_side_event_identity = null;
        fillerArray = new AbstractEventIDByteArrayFiller[]{new ByteEventIDByteArrayFiller(), new ShortEventIDByteArrayFiller(), new IntegerEventIDByteArrayFiller(), new LongEventIDByteArrayFiller()};
    }

    static class ThreadAndSequenceIDWrapper {
        final long threadID = atmLong.incrementAndGet();
        long sequenceID = 0L;
        private static AtomicLong atmLong = new AtomicLong(0L);

        ThreadAndSequenceIDWrapper() {
        }

        long getAndIncrementSequenceID() {
            return this.sequenceID++;
        }

        void reserveSequenceID(int size) {
            this.sequenceID += (long)size;
        }
    }

    protected static class LongEventIDByteArrayFiller
    extends AbstractEventIDByteArrayFiller {
        private static final byte EVENTID_LONG = 3;

        protected LongEventIDByteArrayFiller() {
        }

        @Override
        public void fill(ByteBuffer buffer, long id) {
            buffer.put((byte)3);
            buffer.putLong(id);
        }

        @Override
        public long read(ByteBuffer buffer) {
            long value = buffer.getLong();
            return value;
        }
    }

    protected static class IntegerEventIDByteArrayFiller
    extends AbstractEventIDByteArrayFiller {
        private static final byte EVENTID_INT = 2;

        protected IntegerEventIDByteArrayFiller() {
        }

        @Override
        public void fill(ByteBuffer buffer, long id) {
            buffer.put((byte)2);
            buffer.putInt((int)id);
        }

        @Override
        public long read(ByteBuffer buffer) {
            long value = buffer.getInt();
            return value;
        }
    }

    protected static class ShortEventIDByteArrayFiller
    extends AbstractEventIDByteArrayFiller {
        private static final byte EVENTID_SHORT = 1;

        protected ShortEventIDByteArrayFiller() {
        }

        @Override
        public void fill(ByteBuffer buffer, long id) {
            buffer.put((byte)1);
            buffer.putShort((short)id);
        }

        @Override
        public long read(ByteBuffer buffer) {
            long value = buffer.getShort();
            return value;
        }
    }

    protected static class ByteEventIDByteArrayFiller
    extends AbstractEventIDByteArrayFiller {
        private static final byte EVENTID_BYTE = 0;

        protected ByteEventIDByteArrayFiller() {
        }

        @Override
        public void fill(ByteBuffer buffer, long id) {
            buffer.put((byte)0);
            buffer.put((byte)id);
        }

        @Override
        public long read(ByteBuffer buffer) {
            long value = buffer.get();
            return value;
        }
    }

    protected static abstract class AbstractEventIDByteArrayFiller {
        protected AbstractEventIDByteArrayFiller() {
        }

        public abstract void fill(ByteBuffer var1, long var2);

        public abstract long read(ByteBuffer var1);
    }
}

