/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.RegionMembershipListener;
import org.apache.geode.cache.RegionRoleListener;
import org.apache.geode.cache.RoleEvent;
import org.apache.geode.internal.cache.LocalRegion;

public abstract class EnumListenerEvent {
    private final String name;
    public static final EnumListenerEvent AFTER_CREATE = new AFTER_CREATE();
    public static final EnumListenerEvent AFTER_UPDATE = new AFTER_UPDATE();
    public static final EnumListenerEvent AFTER_INVALIDATE = new AFTER_INVALIDATE();
    public static final EnumListenerEvent AFTER_DESTROY = new AFTER_DESTROY();
    public static final EnumListenerEvent AFTER_REGION_CREATE = new AFTER_REGION_CREATE();
    public static final EnumListenerEvent AFTER_REGION_INVALIDATE = new AFTER_REGION_INVALIDATE();
    public static final EnumListenerEvent AFTER_REGION_CLEAR = new AFTER_REGION_CLEAR();
    public static final EnumListenerEvent AFTER_REGION_DESTROY = new AFTER_REGION_DESTROY();
    public static final EnumListenerEvent AFTER_REMOTE_REGION_CREATE = new AFTER_REMOTE_REGION_CREATE();
    public static final EnumListenerEvent AFTER_REMOTE_REGION_DEPARTURE = new AFTER_REMOTE_REGION_DEPARTURE();
    public static final EnumListenerEvent AFTER_REMOTE_REGION_CRASH = new AFTER_REMOTE_REGION_CRASH();
    public static final EnumListenerEvent AFTER_ROLE_GAIN = new AFTER_ROLE_GAIN();
    public static final EnumListenerEvent AFTER_ROLE_LOSS = new AFTER_ROLE_LOSS();
    public static final EnumListenerEvent AFTER_REGION_LIVE = new AFTER_REGION_LIVE();
    public static final EnumListenerEvent AFTER_REGISTER_INSTANTIATOR = new AFTER_REGISTER_INSTANTIATOR();
    public static final EnumListenerEvent AFTER_REGISTER_DATASERIALIZER = new AFTER_REGISTER_DATASERIALIZER();
    public static final EnumListenerEvent AFTER_TOMBSTONE_EXPIRATION = new AFTER_TOMBSTONE_EXPIRATION();
    public static final EnumListenerEvent TIMESTAMP_UPDATE = new TIMESTAMP_UPDATE();
    private static EnumListenerEvent[] instances = new EnumListenerEvent[]{AFTER_CREATE, AFTER_UPDATE, AFTER_INVALIDATE, AFTER_DESTROY, AFTER_REGION_CREATE, AFTER_REGION_INVALIDATE, AFTER_REGION_CLEAR, AFTER_REGION_DESTROY, AFTER_REMOTE_REGION_CREATE, AFTER_REMOTE_REGION_DEPARTURE, AFTER_REMOTE_REGION_CRASH, AFTER_ROLE_GAIN, AFTER_ROLE_LOSS, AFTER_REGION_LIVE, AFTER_REGISTER_INSTANTIATOR, AFTER_REGISTER_DATASERIALIZER, AFTER_TOMBSTONE_EXPIRATION, TIMESTAMP_UPDATE};

    protected EnumListenerEvent(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public abstract byte getEventCode();

    public abstract void dispatchEvent(CacheEvent var1, CacheListener var2);

    public static EnumListenerEvent getEnumListenerEvent(int eventCode) {
        if (eventCode > 0 && eventCode <= instances.length) {
            return instances[eventCode - 1];
        }
        return null;
    }

    static {
        for (int i = 0; i < instances.length; ++i) {
            assert (instances[i].getEventCode() == i + 1) : "event is in the wrong place: " + (i + 1);
        }
    }

    private static class TIMESTAMP_UPDATE
    extends EnumListenerEvent {
        protected TIMESTAMP_UPDATE() {
            super("TIMESTAMP_UPDATE");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
        }

        @Override
        public byte getEventCode() {
            return 18;
        }
    }

    private static class AFTER_TOMBSTONE_EXPIRATION
    extends EnumListenerEvent {
        protected AFTER_TOMBSTONE_EXPIRATION() {
            super("AFTER_TOMBSTONE_EXPIRATION");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
        }

        @Override
        public byte getEventCode() {
            return 17;
        }
    }

    private static class AFTER_REGISTER_DATASERIALIZER
    extends EnumListenerEvent {
        protected AFTER_REGISTER_DATASERIALIZER() {
            super("AFTER_REGISTER_DATASERIALIZER");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
        }

        @Override
        public byte getEventCode() {
            return 16;
        }
    }

    private static class AFTER_REGISTER_INSTANTIATOR
    extends EnumListenerEvent {
        protected AFTER_REGISTER_INSTANTIATOR() {
            super("AFTER_REGISTER_INSTANTIATOR");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
        }

        @Override
        public byte getEventCode() {
            return 15;
        }
    }

    private static class AFTER_REGION_LIVE
    extends EnumListenerEvent {
        protected AFTER_REGION_LIVE() {
            super("AFTER_REGION_LIVE");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            listener.afterRegionLive((RegionEvent)event);
        }

        @Override
        public byte getEventCode() {
            return 14;
        }
    }

    private static class AFTER_ROLE_LOSS
    extends EnumListenerEvent {
        protected AFTER_ROLE_LOSS() {
            super("AFTER_ROLE_LOSS");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            if (listener instanceof RegionRoleListener) {
                ((RegionRoleListener)listener).afterRoleLoss((RoleEvent)event);
            }
        }

        @Override
        public byte getEventCode() {
            return 13;
        }
    }

    private static class AFTER_ROLE_GAIN
    extends EnumListenerEvent {
        protected AFTER_ROLE_GAIN() {
            super("AFTER_ROLE_GAIN");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            if (listener instanceof RegionRoleListener) {
                ((RegionRoleListener)listener).afterRoleGain((RoleEvent)event);
            }
        }

        @Override
        public byte getEventCode() {
            return 12;
        }
    }

    private static class AFTER_REMOTE_REGION_CRASH
    extends EnumListenerEvent {
        protected AFTER_REMOTE_REGION_CRASH() {
            super("AFTER_REMOTE_REGION_CRASH");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            if (listener instanceof RegionMembershipListener) {
                ((RegionMembershipListener)listener).afterRemoteRegionCrash((RegionEvent)event);
            }
        }

        @Override
        public byte getEventCode() {
            return 11;
        }
    }

    private static class AFTER_REMOTE_REGION_DEPARTURE
    extends EnumListenerEvent {
        protected AFTER_REMOTE_REGION_DEPARTURE() {
            super("AFTER_REMOTE_REGION_DEPARTURE");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            if (listener instanceof RegionMembershipListener) {
                ((RegionMembershipListener)listener).afterRemoteRegionDeparture((RegionEvent)event);
            }
        }

        @Override
        public byte getEventCode() {
            return 10;
        }
    }

    private static class AFTER_REMOTE_REGION_CREATE
    extends EnumListenerEvent {
        protected AFTER_REMOTE_REGION_CREATE() {
            super("AFTER_REMOTE_REGION_CREATE");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            if (listener instanceof RegionMembershipListener) {
                ((RegionMembershipListener)listener).afterRemoteRegionCreate((RegionEvent)event);
            }
        }

        @Override
        public byte getEventCode() {
            return 9;
        }
    }

    private static class AFTER_REGION_DESTROY
    extends EnumListenerEvent {
        protected AFTER_REGION_DESTROY() {
            super("AFTER_REGION_DESTROY");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            listener.afterRegionDestroy((RegionEvent)event);
            ((LocalRegion)event.getRegion()).closeCacheCallback(listener);
        }

        @Override
        public byte getEventCode() {
            return 8;
        }
    }

    private static class AFTER_REGION_CLEAR
    extends EnumListenerEvent {
        protected AFTER_REGION_CLEAR() {
            super("AFTER_REGION_CLEAR");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            listener.afterRegionClear((RegionEvent)event);
        }

        @Override
        public byte getEventCode() {
            return 7;
        }
    }

    private static class AFTER_REGION_INVALIDATE
    extends EnumListenerEvent {
        protected AFTER_REGION_INVALIDATE() {
            super("AFTER_REGION_INVALIDATE");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            listener.afterRegionInvalidate((RegionEvent)event);
        }

        @Override
        public byte getEventCode() {
            return 6;
        }
    }

    private static class AFTER_REGION_CREATE
    extends EnumListenerEvent {
        protected AFTER_REGION_CREATE() {
            super("AFTER_REGION_CREATE");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            listener.afterRegionCreate((RegionEvent)event);
        }

        @Override
        public byte getEventCode() {
            return 5;
        }
    }

    private static class AFTER_DESTROY
    extends EnumListenerEvent {
        protected AFTER_DESTROY() {
            super("AFTER_DESTROY");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            listener.afterDestroy((EntryEvent)event);
        }

        @Override
        public byte getEventCode() {
            return 4;
        }
    }

    private static class AFTER_INVALIDATE
    extends EnumListenerEvent {
        protected AFTER_INVALIDATE() {
            super("AFTER_INVALIDATE");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            listener.afterInvalidate((EntryEvent)event);
        }

        @Override
        public byte getEventCode() {
            return 3;
        }
    }

    private static class AFTER_UPDATE
    extends EnumListenerEvent {
        protected AFTER_UPDATE() {
            super("AFTER_UPDATE");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            listener.afterUpdate((EntryEvent)event);
        }

        @Override
        public byte getEventCode() {
            return 2;
        }
    }

    private static class AFTER_CREATE
    extends EnumListenerEvent {
        protected AFTER_CREATE() {
            super("AFTER_CREATE");
        }

        @Override
        public void dispatchEvent(CacheEvent event, CacheListener listener) {
            listener.afterCreate((EntryEvent)event);
        }

        @Override
        public byte getEventCode() {
            return 1;
        }
    }
}

