/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.NullDataOutputStream;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PreferBytesCachedDeserializable;
import org.apache.geode.internal.cache.StoreAllCachedDeserializable;
import org.apache.geode.internal.cache.VMCachedDeserializable;
import org.apache.geode.internal.cache.lru.Sizeable;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.pdx.PdxInstance;

public class CachedDeserializableFactory {
    public static boolean PREFER_DESERIALIZED = !Boolean.getBoolean("gemfire.PREFER_SERIALIZED");
    public static boolean STORE_ALL_VALUE_FORMS = Boolean.getBoolean("gemfire.STORE_ALL_VALUE_FORMS");

    public static CachedDeserializable create(byte[] v) {
        if (STORE_ALL_VALUE_FORMS) {
            return new StoreAllCachedDeserializable(v);
        }
        if (PREFER_DESERIALIZED) {
            if (CachedDeserializableFactory.isPdxEncoded(v) && CachedDeserializableFactory.cachePrefersPdx()) {
                return new PreferBytesCachedDeserializable(v);
            }
            return new VMCachedDeserializable(v);
        }
        return new PreferBytesCachedDeserializable(v);
    }

    private static boolean isPdxEncoded(byte[] v) {
        if (v.length > 0) {
            return v[0] == 93;
        }
        return false;
    }

    public static CachedDeserializable create(Object object, int serializedSize) {
        if (STORE_ALL_VALUE_FORMS) {
            return new StoreAllCachedDeserializable(object);
        }
        if (PREFER_DESERIALIZED) {
            if (object instanceof PdxInstance && CachedDeserializableFactory.cachePrefersPdx()) {
                return new PreferBytesCachedDeserializable(object);
            }
            return new VMCachedDeserializable(object, serializedSize);
        }
        return new PreferBytesCachedDeserializable(object);
    }

    private static boolean cachePrefersPdx() {
        GemFireCacheImpl internalCache = GemFireCacheImpl.getInstance();
        return internalCache != null && internalCache.getPdxReadSerialized();
    }

    public static CachedDeserializable create(CachedDeserializable cd) {
        if (STORE_ALL_VALUE_FORMS) {
            return cd;
        }
        if (PREFER_DESERIALIZED) {
            if (cd instanceof PreferBytesCachedDeserializable) {
                return cd;
            }
            return new VMCachedDeserializable((VMCachedDeserializable)cd);
        }
        return cd;
    }

    public static int overhead() {
        if (STORE_ALL_VALUE_FORMS) {
            return 16;
        }
        if (PREFER_DESERIALIZED) {
            return 16;
        }
        return 12;
    }

    public static int getByteSize(byte[] serializedValue) {
        return serializedValue.length + 8 + 4;
    }

    public static int getArrayOfBytesSize(byte[][] value, boolean addObjectOverhead) {
        int result = 4 * (value.length + 1);
        if (addObjectOverhead) {
            result += 8 * (value.length + 1);
        }
        for (byte[] bytes : value) {
            if (bytes == null) continue;
            result += bytes.length;
        }
        return result;
    }

    public static int calcMemSize(Object o) {
        return CachedDeserializableFactory.calcMemSize(o, null, true);
    }

    public static int calcMemSize(Object o, ObjectSizer os, boolean addOverhead) {
        return CachedDeserializableFactory.calcMemSize(o, os, addOverhead, true);
    }

    public static int calcMemSize(Object o, ObjectSizer os, boolean addOverhead, boolean calcSerializedSize) {
        int result;
        if (o instanceof byte[]) {
            result = CachedDeserializableFactory.getByteSize((byte[])o);
            addOverhead = false;
        } else if (o == null) {
            result = 0;
            addOverhead = false;
        } else if (o instanceof String) {
            result = ((String)o).length() * 2 + 4 + 16 + 4 + 4 + 4 + 4;
        } else if (o instanceof byte[][]) {
            result = CachedDeserializableFactory.getArrayOfBytesSize((byte[][])o, true);
            addOverhead = false;
        } else if (o instanceof CachedDeserializable) {
            result = ((CachedDeserializable)o).getSizeInBytes();
            addOverhead = false;
        } else if (o instanceof Sizeable) {
            result = ((Sizeable)o).getSizeInBytes();
        } else if (os != null) {
            result = os.sizeof(o);
        } else if (calcSerializedSize) {
            result = 12;
            NullDataOutputStream dos = new NullDataOutputStream();
            try {
                DataSerializer.writeObject(o, dos);
                result += dos.size();
            }
            catch (IOException ex) {
                IllegalArgumentException ex2 = new IllegalArgumentException(LocalizedStrings.CachedDeserializableFactory_COULD_NOT_CALCULATE_SIZE_OF_OBJECT.toLocalizedString());
                ex2.initCause(ex);
                throw ex2;
            }
        } else {
            result = -1;
            addOverhead = false;
        }
        if (addOverhead) {
            result += CachedDeserializableFactory.overhead();
        }
        return result;
    }

    public static int calcSerializedSize(Object o) {
        int result;
        if (o instanceof byte[]) {
            result = CachedDeserializableFactory.getByteSize((byte[])o) - 8;
        } else if (o instanceof byte[][]) {
            result = CachedDeserializableFactory.getArrayOfBytesSize((byte[][])o, false);
        } else if (o instanceof CachedDeserializable) {
            result = ((CachedDeserializable)o).getSizeInBytes() + 4 - CachedDeserializableFactory.overhead();
        } else if (o instanceof Sizeable) {
            result = ((Sizeable)o).getSizeInBytes() + 4;
        } else if (o instanceof HeapDataOutputStream) {
            result = ((HeapDataOutputStream)o).size() + 4;
        } else {
            result = 4;
            NullDataOutputStream dos = new NullDataOutputStream();
            try {
                DataSerializer.writeObject(o, dos);
                result += dos.size();
            }
            catch (IOException ex) {
                IllegalArgumentException ex2 = new IllegalArgumentException(LocalizedStrings.CachedDeserializableFactory_COULD_NOT_CALCULATE_SIZE_OF_OBJECT.toLocalizedString());
                ex2.initCause(ex);
                throw ex2;
            }
        }
        return result;
    }

    public static int calcSerializedMemSize(Object o) {
        int result = CachedDeserializableFactory.calcSerializedSize(o);
        result += 8;
        if (!(o instanceof byte[])) {
            result += CachedDeserializableFactory.overhead();
        }
        return result;
    }
}

