/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class AddCacheServerProfileMessage
extends SerialDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    int processorId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
        try {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null && !cache.isClosed()) {
                this.operateOnCache(cache);
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
            ReplyMessage reply = new ReplyMessage();
            reply.setProcessorId(this.processorId);
            reply.setRecipient(this.getSender());
            try {
                dm.putOutgoing(reply);
            }
            catch (CancelException cancelException) {}
        }
    }

    private void operateOnCache(InternalCache cache) {
        CacheDistributionAdvisor.CacheProfile cp;
        CacheDistributionAdvisor cda;
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (DistributedRegion distributedRegion : this.getDistributedRegions(cache)) {
            cda = distributedRegion.getDistributionAdvisor();
            cp = (CacheDistributionAdvisor.CacheProfile)cda.getProfile(this.getSender());
            if (cp == null) continue;
            if (isDebugEnabled) {
                logger.debug("Setting hasCacheServer flag on region \"{}\" for {}", (Object)distributedRegion.getFullPath(), (Object)this.getSender());
            }
            cp.hasCacheServer = true;
        }
        for (PartitionedRegion partitionedRegion : this.getPartitionedRegions(cache)) {
            cda = (CacheDistributionAdvisor)partitionedRegion.getDistributionAdvisor();
            cp = (CacheDistributionAdvisor.CacheProfile)cda.getProfile(this.getSender());
            if (cp == null) continue;
            if (isDebugEnabled) {
                logger.debug("Setting hasCacheServer flag on region \"{}\" for {}", (Object)partitionedRegion.getFullPath(), (Object)this.getSender());
            }
            cp.hasCacheServer = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operateOnLocalCache(InternalCache cache) {
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
        try {
            FilterProfile fp;
            for (LocalRegion localRegion : this.getAllRegions(cache)) {
                fp = localRegion.getFilterProfile();
                if (fp == null) continue;
                fp.getLocalProfile().hasCacheServer = true;
            }
            for (PartitionedRegion partitionedRegion : this.getPartitionedRegions(cache)) {
                fp = partitionedRegion.getFilterProfile();
                if (fp == null) continue;
                fp.getLocalProfile().hasCacheServer = true;
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
    }

    private Set<LocalRegion> getAllRegions(InternalCache internalCache) {
        return internalCache.getAllRegions();
    }

    private Set<DistributedRegion> getDistributedRegions(InternalCache internalCache) {
        HashSet<DistributedRegion> result = new HashSet<DistributedRegion>();
        for (LocalRegion r : internalCache.getAllRegions()) {
            if (!(r instanceof DistributedRegion)) continue;
            result.add((DistributedRegion)r);
        }
        return result;
    }

    private Set<PartitionedRegion> getPartitionedRegions(InternalCache internalCache) {
        return new HashSet<PartitionedRegion>(internalCache.getPartitionedRegions());
    }

    @Override
    public int getDSFID() {
        return -118;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
    }

    @Override
    public String toString() {
        return this.getShortClassName() + "(processorId=" + this.processorId + ")";
    }
}

