/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.admin.remote.RemoteGemFireVM;
import org.apache.geode.internal.admin.remote.RemoteGfManagerAgent;

public class StatListenerMessage
extends PooledDistributionMessage
implements AdminMessageType {
    private long timestamp;
    private int changeCount;
    private transient int[] listenerIds;
    private transient double[] values;

    public static StatListenerMessage create(long timestamp, int maxChanges) {
        StatListenerMessage m = new StatListenerMessage();
        m.timestamp = timestamp;
        m.changeCount = 0;
        m.listenerIds = new int[maxChanges];
        m.values = new double[maxChanges];
        return m;
    }

    public void addChange(int listenerId, double value) {
        this.listenerIds[this.changeCount] = listenerId;
        this.values[this.changeCount] = value;
        ++this.changeCount;
    }

    @Override
    public void process(DistributionManager dm) {
        RemoteGemFireVM mgr;
        RemoteGfManagerAgent agent = dm.getAgent();
        if (agent != null && (mgr = agent.getMemberById(this.getSender())) != null) {
            mgr.callStatListeners(this.timestamp, this.listenerIds, this.values);
        }
    }

    @Override
    public int getDSFID() {
        return 1056;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeLong(this.timestamp);
        out.writeInt(this.changeCount);
        for (int i = 0; i < this.changeCount; ++i) {
            out.writeInt(this.listenerIds[i]);
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.timestamp = in.readLong();
        this.changeCount = in.readInt();
        this.listenerIds = new int[this.changeCount];
        this.values = new double[this.changeCount];
        for (int i = 0; i < this.changeCount; ++i) {
            this.listenerIds[i] = in.readInt();
            this.values[i] = in.readDouble();
        }
    }
}

