/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.StatAlertsManager;

public class StatAlertsManagerAssignMessage
extends PooledDistributionMessage {
    private StatAlertDefinition[] alertDefs;
    private long refreshInterval;

    public StatAlertsManagerAssignMessage() {
        this.alertDefs = null;
        this.refreshInterval = -1L;
    }

    public StatAlertsManagerAssignMessage(StatAlertDefinition[] alertDefs, long refreshInterval) {
        this.alertDefs = alertDefs;
        this.refreshInterval = refreshInterval;
    }

    public static StatAlertsManagerAssignMessage create(StatAlertDefinition[] alertDefs, long refreshInterval) {
        return new StatAlertsManagerAssignMessage(alertDefs, refreshInterval);
    }

    @Override
    protected void process(DistributionManager dm) {
        this.setManager(dm);
    }

    private void setManager(DistributionManager dm) {
        StatAlertsManager manager = StatAlertsManager.getInstance(dm);
        manager.updateAlertDefinition(this.alertDefs, 1);
        manager.setRefreshTimeInterval(this.refreshInterval);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeLong(this.refreshInterval);
        DataSerializer.writeObjectArray(this.alertDefs, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.refreshInterval = in.readLong();
        this.alertDefs = (StatAlertDefinition[])DataSerializer.readObjectArray(in);
    }

    @Override
    public int getDSFID() {
        return 1065;
    }

    @Override
    public String toString() {
        return "StatAlertsManagerAssignRequest from " + this.getSender();
    }
}

