/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.internal.admin.CacheInfo;
import org.apache.geode.internal.admin.StatResource;
import org.apache.geode.internal.admin.remote.RemoteGemFireVM;
import org.apache.geode.internal.admin.remote.RemoteStatResource;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class RemoteCacheInfo
implements CacheInfo,
DataSerializable {
    private static final long serialVersionUID = 4251279100323876440L;
    private String name;
    private int id;
    private boolean closed;
    private int lockTimeout;
    private int lockLease;
    private int searchTimeout;
    private int upTime;
    private String[] rootRegionNames;
    private RemoteStatResource perfStats;
    private int[] bridgeServerIds;
    private boolean isServer;

    public RemoteCacheInfo(InternalCache internalCache) {
        this.name = internalCache.getName();
        this.id = System.identityHashCode(internalCache);
        this.closed = internalCache.isClosed();
        this.lockTimeout = internalCache.getLockTimeout();
        this.lockLease = internalCache.getLockLease();
        this.searchTimeout = internalCache.getSearchTimeout();
        this.upTime = internalCache.getUpTime();
        if (this.closed) {
            this.rootRegionNames = null;
            this.perfStats = null;
            this.bridgeServerIds = new int[0];
        } else {
            try {
                Set<Region<?, ?>> roots = !Boolean.getBoolean("gemfire.PRDebug") ? internalCache.rootRegions() : internalCache.rootRegions(true);
                String[] rootNames = new String[roots.size()];
                int idx = 0;
                Iterator<Region<?, ?>> iterator = roots.iterator();
                while (iterator.hasNext()) {
                    Region<?, ?> root;
                    Region<?, ?> r = root = iterator.next();
                    rootNames[idx] = r.getName();
                    ++idx;
                }
                this.rootRegionNames = rootNames;
            }
            catch (CacheRuntimeException ignore) {
                this.rootRegionNames = null;
            }
            this.perfStats = new RemoteStatResource(internalCache.getCachePerfStats().getStats());
            List<CacheServer> bridges = internalCache.getCacheServers();
            this.bridgeServerIds = new int[bridges.size()];
            Iterator iter = bridges.iterator();
            int i = 0;
            while (iter.hasNext()) {
                CacheServer bridge = (CacheServer)iter.next();
                this.bridgeServerIds[i] = System.identityHashCode(bridge);
                ++i;
            }
            this.isServer = internalCache.isServer();
        }
    }

    public RemoteCacheInfo() {
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.name, out);
        out.writeInt(this.id);
        out.writeBoolean(this.closed);
        out.writeInt(this.lockTimeout);
        out.writeInt(this.lockLease);
        out.writeInt(this.searchTimeout);
        out.writeInt(this.upTime);
        DataSerializer.writeStringArray(this.rootRegionNames, out);
        DataSerializer.writeObject(this.perfStats, out);
        DataSerializer.writeIntArray(this.bridgeServerIds, out);
        out.writeBoolean(this.isServer);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.name = DataSerializer.readString(in);
        this.id = in.readInt();
        this.closed = in.readBoolean();
        this.lockTimeout = in.readInt();
        this.lockLease = in.readInt();
        this.searchTimeout = in.readInt();
        this.upTime = in.readInt();
        this.rootRegionNames = DataSerializer.readStringArray(in);
        this.perfStats = (RemoteStatResource)DataSerializer.readObject(in);
        this.bridgeServerIds = DataSerializer.readIntArray(in);
        this.isServer = in.readBoolean();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public int getLockLease() {
        return this.lockLease;
    }

    @Override
    public int getSearchTimeout() {
        return this.searchTimeout;
    }

    @Override
    public int getUpTime() {
        return this.upTime;
    }

    @Override
    public synchronized Set getRootRegionNames() {
        if (this.rootRegionNames == null) {
            return null;
        }
        return new TreeSet<String>(Arrays.asList(this.rootRegionNames));
    }

    @Override
    public StatResource getPerfStats() {
        return this.perfStats;
    }

    @Override
    public synchronized void setClosed() {
        this.closed = true;
        this.rootRegionNames = null;
    }

    @Override
    public int[] getBridgeServerIds() {
        return this.bridgeServerIds;
    }

    @Override
    public boolean isServer() {
        return this.isServer;
    }

    void setGemFireVM(RemoteGemFireVM vm) {
        if (this.perfStats != null) {
            this.perfStats.setGemFireVM(vm);
        }
    }

    public String toString() {
        return LocalizedStrings.RemoteCacheInfo_INFORMATION_ABOUT_THE_CACHE_0_WITH_1_BRIDGE_SERVERS.toLocalizedString(this.name, this.bridgeServerIds.length);
    }
}

