/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.lang.ref.WeakReference;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ObjIdMap {
    protected Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    public final Object rehashLock = new Object();

    public ObjIdMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(LocalizedStrings.ObjIdMap_ILLEGAL_INITIAL_CAPACITY_0.toLocalizedString(initialCapacity));
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException(LocalizedStrings.ObjIdMap_ILLEGAL_LOAD_FACTOR_0.toLocalizedString(new Float(loadFactor)));
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public ObjIdMap() {
        this(11, 0.75f);
    }

    public ObjIdMap(ObjIdMap oldMap, int addKey, Object addValue) {
        this.loadFactor = oldMap.loadFactor;
        this.rehash(oldMap.table, oldMap.count, oldMap.count + 2);
        this.put(addKey, addValue);
    }

    public ObjIdMap(ObjIdMap oldMap) {
        this.table = new Entry[oldMap.table.length];
        System.arraycopy(oldMap.table, 0, this.table, 0, this.table.length);
        this.count = oldMap.count;
        this.threshold = oldMap.threshold;
        this.loadFactor = oldMap.loadFactor;
    }

    public int size() {
        return this.count;
    }

    public boolean containsKey(int key) {
        Entry[] table = this.table;
        int bucket = Math.abs(key) % table.length;
        Entry e = table[bucket];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(int key) {
        Entry[] table = this.table;
        int bucket = Math.abs(key) % table.length;
        Entry e = table[bucket];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private void rehash() {
        this.rehash(this.table, this.count, this.count * 2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rehash(Entry[] oldMap, int newCount, int newCapacity) {
        int oldCapacity = oldMap.length;
        Entry[] newMap = new Entry[newCapacity];
        Object object = this.rehashLock;
        synchronized (object) {
            int i = oldCapacity;
            while (i-- > 0) {
                Entry old = oldMap[i];
                while (old != null) {
                    WeakReference r;
                    Entry e = old;
                    old = old.next;
                    if (e.value != null && e.value instanceof WeakReference && (r = (WeakReference)e.value).get() == null) {
                        --newCount;
                        continue;
                    }
                    int index = Math.abs(e.key) % newCapacity;
                    e.next = newMap[index];
                    newMap[index] = e;
                }
            }
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            this.count = newCount;
            this.table = newMap;
        }
    }

    public Object put(int key, Object value) {
        int bucket = Math.abs(key) % this.table.length;
        Entry e = this.table[bucket];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            bucket = Math.abs(key) % this.table.length;
        }
        e = new Entry();
        e.key = key;
        e.value = value;
        e.next = this.table[bucket];
        this.table[bucket] = e;
        ++this.count;
        return null;
    }

    public Object remove(int key) {
        Entry[] table = this.table;
        int bucket = Math.abs(key) % table.length;
        Entry e = table[bucket];
        Entry prev = null;
        while (e != null) {
            if (key == e.key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    table[bucket] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public Object[] values() {
        Object[] values = new Object[this.size()];
        Entry[] table = this.table;
        int i = 0;
        for (int bucket = 0; bucket < table.length; ++bucket) {
            Entry e = table[bucket];
            while (e != null) {
                values[i++] = e.value;
                e = e.next;
            }
        }
        return values;
    }

    public EntryIterator iterator() {
        return new EntryIterator();
    }

    public class EntryIterator {
        private int index = 0;
        private Entry next = null;

        public Entry next() {
            while (this.next == null && this.index < ObjIdMap.this.table.length) {
                if (ObjIdMap.this.table[this.index] != null) {
                    this.next = ObjIdMap.this.table[this.index];
                }
                ++this.index;
            }
            Entry oldNext = this.next;
            if (oldNext != null) {
                this.next = oldNext.next;
            }
            return oldNext;
        }
    }

    public static class Entry {
        int key;
        Object value;
        Entry next;

        public int getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

