/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

public class NanoTimer {
    public static final long NANOS_PER_MILLISECOND = 1000000L;
    private final long constructionTime;
    private long lastResetTime;
    private final TimeService timeService;
    private static final TimeService systemTimeService = new TimeService(){

        @Override
        public long getTime() {
            return System.nanoTime();
        }
    };

    public NanoTimer() {
        this.timeService = systemTimeService;
        this.constructionTime = this.lastResetTime = systemTimeService.getTime();
    }

    protected NanoTimer(TimeService ts) {
        this.timeService = ts;
        this.constructionTime = this.lastResetTime = ts.getTime();
    }

    public static long nanosToMillis(long nanos) {
        return nanos / 1000000L;
    }

    public static long millisToNanos(long millis) {
        return millis * 1000000L;
    }

    public static long getTime() {
        return System.nanoTime();
    }

    public long getConstructionTime() {
        return this.constructionTime;
    }

    public long getLastResetTime() {
        return this.lastResetTime;
    }

    public long reset() {
        long save = this.lastResetTime;
        this.lastResetTime = this.timeService.getTime();
        return this.lastResetTime - save;
    }

    public long getTimeSinceReset() {
        return this.timeService.getTime() - this.lastResetTime;
    }

    public long getTimeSinceConstruction() {
        return this.timeService.getTime() - this.constructionTime;
    }

    public static interface TimeService {
        public long getTime();
    }
}

