/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.admin.internal.InetAddressUtil;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class MigrationServer {
    private static final Logger logger = LogService.getLogger();
    static final boolean VERBOSE = Boolean.getBoolean("Migration.VERBOSE");
    private static final int VERSION = 551;
    static final int CODE_ERROR = 0;
    static final int CODE_ENTRY = 1;
    static final int CODE_COMPLETED = 2;
    private InetAddress bindAddress;
    private final int listenPort;
    private ServerSocket serverSocket;
    private DistributedSystem distributedSystem;
    private File cacheXmlFile;
    private Cache cache;

    public static void main(String[] args) throws Exception {
        int argIdx = 0;
        String cacheXmlFileName = "cache.xml";
        if (args.length > 0) {
            cacheXmlFileName = args[argIdx++];
        } else {
            System.err.println("MigrationServer cache-xml-file [server-address] [server-port]");
        }
        int listenPort = 10533;
        if (args.length > argIdx) {
            listenPort = Integer.parseInt(args[argIdx++]);
        }
        String bindAddressName = null;
        if (args.length > argIdx) {
            bindAddressName = args[argIdx++];
        }
        MigrationServer instance = null;
        try {
            instance = new MigrationServer(cacheXmlFileName, bindAddressName, listenPort);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        instance.createDistributedSystem();
        instance.createCache();
        instance.serve();
    }

    private MigrationServer(String bindAddressName, int listenPort) {
        this.listenPort = listenPort;
        if (bindAddressName != null) {
            if (!MigrationServer.isLocalHost(bindAddressName)) {
                throw new IllegalArgumentException("Error - bind address is not an address of this machine: '" + bindAddressName + '\'');
            }
            try {
                this.bindAddress = InetAddress.getByName(bindAddressName);
            }
            catch (IOException ignore) {
                throw new IllegalArgumentException("Error - bind address cannot be resolved: '" + bindAddressName + '\'');
            }
        }
        try {
            if (this.bindAddress != null) {
                this.serverSocket = new ServerSocket();
                InetSocketAddress addr = new InetSocketAddress(this.bindAddress, listenPort);
                this.serverSocket.bind(addr);
            } else {
                this.serverSocket = new ServerSocket(listenPort);
            }
            if (VERBOSE) {
                System.out.println("created server socket " + this.serverSocket);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Port is already in use", e);
        }
    }

    private MigrationServer(String cacheXmlFileName, String bindAddressName, int listenPort) {
        this(bindAddressName, listenPort);
        this.cacheXmlFile = new File(cacheXmlFileName);
        if (!this.cacheXmlFile.exists()) {
            System.err.println("Warning - file not found in local directory: '" + cacheXmlFileName + '\'');
        }
    }

    private void createDistributedSystem() throws Exception {
        Properties dsProps = new Properties();
        if (System.getProperty("gemfire.mcast-port") == null && System.getProperty("gemfire.locators") == null) {
            dsProps.put("mcast-port", "0");
        }
        dsProps.put("log-file", "migrationServer.log");
        if (this.cacheXmlFile != null) {
            dsProps.put("cache-xml-file", this.cacheXmlFile.getName());
        }
        this.distributedSystem = DistributedSystem.connect(dsProps);
        if (VERBOSE) {
            System.out.println("created distributed system " + this.distributedSystem);
        }
    }

    private void createCache() throws Exception {
        if (this.distributedSystem == null) {
            this.distributedSystem = InternalDistributedSystem.getConnectedInstance();
        }
        this.cache = CacheFactory.create(this.distributedSystem);
        if (VERBOSE) {
            System.out.println("created cache " + this.cache);
        }
    }

    public void serve() throws Exception {
        if (this.serverSocket == null || this.serverSocket.isClosed()) {
            throw new IllegalStateException("This server has been closed and cannot be reused");
        }
        try {
            if (this.distributedSystem == null) {
                this.distributedSystem = InternalDistributedSystem.getConnectedInstance();
            }
            if (this.cache == null) {
                this.cache = GemFireCacheImpl.getInstance();
            }
            if (this.bindAddress != null) {
                System.out.println("Migration server on port " + this.listenPort + " bound to " + this.bindAddress + " is ready for client requets");
            } else {
                System.out.println("Migration server on port " + this.listenPort + " is ready for client requests");
            }
            while (true) {
                Socket clientSocket;
                if (Thread.interrupted() || this.serverSocket.isClosed()) {
                    return;
                }
                try {
                    clientSocket = this.serverSocket.accept();
                }
                catch (SocketException ignored) {
                    System.out.println("Closing migration server");
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception ignore) {
                        this.serverSocket = null;
                    }
                    return;
                }
                new RequestHandler(clientSocket).serveClientRequest();
            }
        }
        finally {
            System.out.println("Closing migration server");
            try {
                this.serverSocket.close();
            }
            catch (Exception ignore) {
                this.serverSocket = null;
            }
        }
    }

    public void stop() throws IOException {
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            this.serverSocket.close();
        }
    }

    public Cache getCache() {
        return this.cache;
    }

    public DistributedSystem getDistributedSystem() {
        return this.distributedSystem;
    }

    public static boolean isLocalHost(Object host) {
        if (host instanceof InetAddress) {
            if (InetAddressUtil.LOCALHOST.equals(host)) {
                return true;
            }
            try {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface i = en.nextElement();
                    Enumeration<InetAddress> en2 = i.getInetAddresses();
                    while (en2.hasMoreElements()) {
                        InetAddress addr = en2.nextElement();
                        if (!host.equals(addr)) continue;
                        return true;
                    }
                }
                return false;
            }
            catch (SocketException e) {
                throw new IllegalArgumentException(LocalizedStrings.InetAddressUtil_UNABLE_TO_QUERY_NETWORK_INTERFACE.toLocalizedString(), e);
            }
        }
        return MigrationServer.isLocalHost(MigrationServer.toInetAddress(host.toString()));
    }

    public static InetAddress toInetAddress(String host) {
        if (host == null || host.length() == 0) {
            return null;
        }
        try {
            if (host.contains("/")) {
                return InetAddress.getByName(host.substring(host.indexOf(47) + 1));
            }
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    static class RegionRequest
    extends ClientRequest {
        String regionName;

        RegionRequest(Socket clientSocket, DataInputStream dsi, DataOutputStream dso) throws IOException {
            super(clientSocket, dsi, dso);
            this.regionName = dsi.readUTF();
        }

        public String toString() {
            return "request for contents of region '" + this.regionName + '\'';
        }

        @Override
        void process(MigrationServer server) throws IOException {
            Cache cache = server.getCache();
            Region region = null;
            try {
                region = cache.getRegion(this.regionName);
                if (region == null) {
                    String errorMessage = "Error: region " + this.regionName + " not found in cache";
                    System.err.println(errorMessage);
                    this.writeErrorResponse(errorMessage);
                }
            }
            catch (IllegalArgumentException e) {
                String errorMessage = "Error: malformed region name";
                logger.warn(errorMessage, (Throwable)e);
                this.writeErrorResponse(errorMessage);
            }
            try {
                for (Map.Entry o : region.entrySet()) {
                    this.sendEntry((Region.Entry)o);
                }
                this.dso.writeShort(2);
            }
            catch (Exception e) {
                this.writeErrorResponse(e.getMessage());
            }
        }

        private void sendEntry(Region.Entry entry) throws IOException {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof Serializable)) {
                throw new IOException("Could not serialize entry for '" + key + '\'');
            }
            if (!(value instanceof Serializable)) {
                throw new IOException("Could not serialize entry for '" + key + '\'');
            }
            if (VERBOSE) {
                System.out.println("Sending " + key);
            }
            this.dso.writeShort(1);
            new ObjectOutputStream(this.clientSocket.getOutputStream()).writeObject(key);
            new ObjectOutputStream(this.clientSocket.getOutputStream()).writeObject(value);
        }
    }

    static abstract class ClientRequest {
        Socket clientSocket;
        DataInputStream dsi;
        DataOutputStream dso;
        static final int REGION_REQUEST = 1;

        ClientRequest(Socket clientSocket, DataInputStream dsi, DataOutputStream dso) throws IOException {
            this.clientSocket = clientSocket;
            this.dsi = dsi;
            this.dso = dso;
        }

        static ClientRequest readRequest(Socket clientSocket, DataInputStream dsi, DataOutputStream dso) throws IOException {
            short requestType = dsi.readShort();
            switch (requestType) {
                case 1: {
                    return new RegionRequest(clientSocket, dsi, dso);
                }
            }
            dso.writeShort(0);
            String errorMessage = "Type of request is not implemented in this server";
            dso.writeUTF(errorMessage);
            System.err.println("Migration server received unknown type of request (" + requestType + ") from " + clientSocket.getInetAddress().getHostAddress());
            return null;
        }

        void writeErrorResponse(String message) throws IOException {
            this.dso.writeShort(0);
            this.dso.writeUTF(message);
        }

        abstract void process(MigrationServer var1) throws IOException;
    }

    class RequestHandler
    implements Runnable {
        Socket clientSocket;
        DataInputStream dis;
        DataOutputStream dos;

        RequestHandler(Socket clientSocket) throws IOException {
            this.clientSocket = clientSocket;
            this.dos = new DataOutputStream(this.clientSocket.getOutputStream());
            this.dis = new DataInputStream(this.clientSocket.getInputStream());
        }

        void serveClientRequest() {
            try {
                this.run();
            }
            finally {
                if (!this.clientSocket.isClosed()) {
                    try {
                        this.clientSocket.close();
                    }
                    catch (IOException e) {
                        logger.debug((Object)e);
                    }
                }
            }
        }

        @Override
        public void run() {
            try {
                this.dos.writeShort(551);
                short version = this.dis.readShort();
                this.handleRequest(version);
            }
            catch (IOException e) {
                System.err.println("Trouble dispatching request: " + e.getMessage());
            }
            finally {
                try {
                    this.clientSocket.close();
                }
                catch (IOException e) {
                    logger.debug("Trouble closing client socket", (Throwable)e);
                }
            }
        }

        private void handleRequest(int clientVersion) {
            try {
                ClientRequest req = ClientRequest.readRequest(this.clientSocket, this.dis, this.dos);
                if (req != null) {
                    System.out.println("Processing " + req + " from " + this.clientSocket.getInetAddress().getHostAddress());
                    req.process(MigrationServer.this);
                    this.dos.flush();
                }
            }
            catch (IOException e) {
                logger.debug((Object)e);
            }
        }
    }
}

