/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.Console;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.util.GfshConsoleReader;

public class GfeConsoleReaderFactory {
    private static GfeConsoleReader defaultConsoleReader = GfeConsoleReaderFactory.createConsoleReader();

    public static GfeConsoleReader getDefaultConsoleReader() {
        return defaultConsoleReader;
    }

    public static GfeConsoleReader createConsoleReader() {
        GfeConsoleReader consoleReader = null;
        if (CliUtil.isGfshVM()) {
            LogWrapper.getInstance().info("GfeConsoleReaderFactory.createConsoleReader(): isGfshVM");
            consoleReader = new GfshConsoleReader();
            LogWrapper.getInstance().info("GfeConsoleReaderFactory.createConsoleReader(): consoleReader: " + consoleReader + "=" + consoleReader.isSupported());
        }
        if (consoleReader == null) {
            consoleReader = new GfeConsoleReader();
        }
        return consoleReader;
    }

    public static class GfeConsoleReader {
        private Console console = System.console();

        protected GfeConsoleReader() {
        }

        public boolean isSupported() {
            return this.console != null;
        }

        public String readLine(String textToPrompt) {
            if (this.isSupported()) {
                return this.console.readLine(textToPrompt, new Object[0]);
            }
            return null;
        }

        public char[] readPassword(String textToPrompt) {
            if (this.isSupported()) {
                return this.console.readPassword(textToPrompt, new Object[0]);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": isSupported=" + this.isSupported();
        }
    }
}

