/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.internal.ClassPathLoader;

public class ClassLoadUtil {
    static Map primTypes;
    static Map wrapperTypes;

    public static Class classFromName(String className) throws ClassNotFoundException {
        Class<?> result = ClassLoadUtil.checkForPrimType(className);
        if (result == null) {
            result = ClassPathLoader.getLatest().forName(className);
        }
        return result;
    }

    public static Method methodFromName(String fullyQualifiedMethodName, Class[] parameterTypes) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        int classIndex = fullyQualifiedMethodName.lastIndexOf(46);
        if (classIndex <= 0) {
            throw new ClassNotFoundException("Static creation function [" + fullyQualifiedMethodName + "] should be fully qualified");
        }
        String className = fullyQualifiedMethodName.substring(0, classIndex);
        if (ClassLoadUtil.checkForPrimType(className) != null) {
            throw new NoSuchMethodException(className + " cannot be one of the primitive types");
        }
        String methodName = fullyQualifiedMethodName.substring(classIndex + 1);
        Class<?> result = ClassPathLoader.getLatest().forName(className);
        return result.getMethod(methodName, parameterTypes);
    }

    public static Method methodFromName(String fullyQualifiedMethodName) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        return ClassLoadUtil.methodFromName(fullyQualifiedMethodName, null);
    }

    public static Class checkForPrimType(String className) {
        return (Class)primTypes.get(className);
    }

    public static Class checkForWrapperType(String className) {
        return (Class)wrapperTypes.get(className);
    }

    static {
        if (primTypes == null) {
            HashMap<String, Class<Object>> ptMap = new HashMap<String, Class<Object>>();
            ptMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
            ptMap.put(Character.TYPE.getName(), Character.TYPE);
            ptMap.put(Byte.TYPE.getName(), Byte.TYPE);
            ptMap.put(Short.TYPE.getName(), Short.TYPE);
            ptMap.put(Integer.TYPE.getName(), Integer.TYPE);
            ptMap.put(Long.TYPE.getName(), Long.TYPE);
            ptMap.put(Float.TYPE.getName(), Float.TYPE);
            ptMap.put(Double.TYPE.getName(), Double.TYPE);
            ptMap.put(Void.TYPE.getName(), Void.TYPE);
            primTypes = ptMap;
        }
        if (wrapperTypes == null) {
            HashMap<String, Class> wtMap = new HashMap<String, Class>();
            wtMap.put(Boolean.TYPE.getName(), Boolean.class);
            wtMap.put(Character.TYPE.getName(), Character.class);
            wtMap.put(Byte.TYPE.getName(), Byte.class);
            wtMap.put(Short.TYPE.getName(), Short.class);
            wtMap.put(Integer.TYPE.getName(), Integer.class);
            wtMap.put(Long.TYPE.getName(), Long.class);
            wtMap.put(Float.TYPE.getName(), Float.class);
            wtMap.put(Double.TYPE.getName(), Double.class);
            wrapperTypes = wtMap;
        }
    }
}

