/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messenger;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.NetView;
import org.apache.geode.distributed.internal.membership.gms.Services;

public class GMSEncrypt
implements Cloneable {
    public static long encodingsPerformed;
    public static long decodingsPerformed;
    private static final BigInteger dhP;
    private static final BigInteger dhG;
    private static final int dhL = 1023;
    private PrivateKey dhPrivateKey = null;
    private PublicKey dhPublicKey = null;
    private String dhSKAlgo = null;
    private Services services;
    private InternalDistributedMember localMember;
    private NetView view;
    public static final int numberOfPeerEncryptorCopies;
    private ConcurrentHashMap<InternalDistributedMember, PeerEncryptor>[] copyOfPeerEncryptors;
    private ClusterEncryptor[] copyOfClusterEncryptors;
    private Map<InternalDistributedMember.InternalDistributedMemberWrapper, byte[]> memberToPeerEncryptor = new ConcurrentHashMap<InternalDistributedMember.InternalDistributedMemberWrapper, byte[]>();
    private ClusterEncryptor clusterEncryptor;

    protected void installView(NetView view) {
        this.view = view;
        this.view.setPublicKey(this.services.getJoinLeave().getMemberID(), this.getPublicKeyBytes());
    }

    protected void installView(NetView view, InternalDistributedMember mbr) {
        this.view = view;
    }

    protected byte[] getClusterSecretKey() {
        return this.clusterEncryptor.secretBytes;
    }

    protected synchronized void initClusterSecretKey() throws Exception {
        if (this.clusterEncryptor == null) {
            this.clusterEncryptor = new ClusterEncryptor(this);
        }
    }

    protected synchronized void addClusterKey(byte[] secretBytes) {
        this.clusterEncryptor = new ClusterEncryptor(secretBytes);
    }

    protected GMSEncrypt() {
        this.initEncryptors();
    }

    private byte[] getRegisteredPublicKey(InternalDistributedMember mbr) {
        return this.services.getPublicKey(mbr);
    }

    public GMSEncrypt(Services services) throws Exception {
        this.services = services;
        this.initEncryptors();
        this.initDHKeys(services.getConfig().getDistributionConfig());
    }

    public GMSEncrypt(Services services, InternalDistributedMember mbr) throws Exception {
        this.services = services;
        this.localMember = mbr;
        this.initEncryptors();
        this.initDHKeys(services.getConfig().getDistributionConfig());
    }

    void initEncryptors() {
        this.copyOfPeerEncryptors = new ConcurrentHashMap[numberOfPeerEncryptorCopies];
        this.copyOfClusterEncryptors = new ClusterEncryptor[numberOfPeerEncryptorCopies];
    }

    public byte[] decryptData(byte[] data, InternalDistributedMember member) throws Exception {
        return this.getPeerEncryptor(member).decryptBytes(data);
    }

    public byte[] encryptData(byte[] data, InternalDistributedMember member) throws Exception {
        return this.getPeerEncryptor(member).encryptBytes(data);
    }

    public byte[] decryptData(byte[] data) throws Exception {
        return this.getClusterEncryptor().decryptBytes(data);
    }

    public byte[] decryptData(byte[] data, byte[] pkBytes) throws Exception {
        PeerEncryptor encryptor = new PeerEncryptor(pkBytes);
        return encryptor.decryptBytes(data);
    }

    public byte[] encryptData(byte[] data) throws Exception {
        return this.getClusterEncryptor().encryptBytes(data);
    }

    protected byte[] getPublicKeyBytes() {
        return this.dhPublicKey.getEncoded();
    }

    protected byte[] getPublicKey(InternalDistributedMember member) {
        try {
            InternalDistributedMember localMbr = this.services.getMessenger().getMemberID();
            if (localMbr != null && localMbr.equals(member)) {
                return this.dhPublicKey.getEncoded();
            }
            return this.getPeerEncryptor(member).peerPublicKey.getEncoded();
        }
        catch (Exception e) {
            throw new RuntimeException("Not found public key for member " + member, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPublicKey(byte[] publickey, InternalDistributedMember mbr) {
        try {
            this.memberToPeerEncryptor.put(new InternalDistributedMember.InternalDistributedMemberWrapper(mbr), publickey);
            ConcurrentHashMap<InternalDistributedMember, PeerEncryptor>[] concurrentHashMapArray = this.copyOfPeerEncryptors;
            synchronized (this.copyOfPeerEncryptors) {
                for (ConcurrentHashMap<InternalDistributedMember, PeerEncryptor> m : this.copyOfPeerEncryptors) {
                    if (m == null) continue;
                    m.remove(mbr);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create peer encryptor " + mbr, e);
        }
        {
            return;
        }
    }

    protected GMSEncrypt clone() throws CloneNotSupportedException {
        try {
            GMSEncrypt gmsEncrypt = new GMSEncrypt();
            gmsEncrypt.localMember = this.localMember;
            gmsEncrypt.dhSKAlgo = this.dhSKAlgo;
            gmsEncrypt.services = this.services;
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(this.dhPublicKey.getEncoded());
            KeyFactory keyFact = KeyFactory.getInstance("DH");
            gmsEncrypt.dhPublicKey = keyFact.generatePublic(x509KeySpec);
            String format = this.dhPrivateKey.getFormat();
            System.out.println("private key format " + format);
            System.out.println("public ksy format " + this.dhPublicKey.getFormat());
            PKCS8EncodedKeySpec x509KeySpecPKey = new PKCS8EncodedKeySpec(this.dhPrivateKey.getEncoded());
            keyFact = KeyFactory.getInstance("DH");
            gmsEncrypt.dhPrivateKey = keyFact.generatePrivate(x509KeySpecPKey);
            return gmsEncrypt;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to clone", e);
        }
    }

    private void initDHKeys(DistributionConfig config) throws Exception {
        this.dhSKAlgo = config.getSecurityUDPDHAlgo();
        if (this.dhSKAlgo != null && this.dhSKAlgo.length() > 0) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DH");
            DHParameterSpec dhSpec = new DHParameterSpec(dhP, dhG, 1023);
            keyGen.initialize(dhSpec);
            KeyPair keypair = keyGen.generateKeyPair();
            this.dhPrivateKey = keypair.getPrivate();
            this.dhPublicKey = keypair.getPublic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PeerEncryptor getPeerEncryptor(InternalDistributedMember member) throws Exception {
        Map<InternalDistributedMember, PeerEncryptor> m = this.getPeerEncryptorMap();
        PeerEncryptor result = m.get(member);
        if (result == null) {
            GMSEncrypt gMSEncrypt = this;
            synchronized (gMSEncrypt) {
                result = m.get(member);
                if (result == null) {
                    byte[] pk = this.memberToPeerEncryptor.get(new InternalDistributedMember.InternalDistributedMemberWrapper(member));
                    if (pk == null) {
                        pk = this.getRegisteredPublicKey(member);
                    }
                    result = this.createPeerEncryptor(member, pk != null ? pk : (byte[])this.view.getPublicKey(member));
                    m.put(member, result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<InternalDistributedMember, PeerEncryptor> getPeerEncryptorMap() {
        int h = Math.abs(Thread.currentThread().getName().hashCode() % numberOfPeerEncryptorCopies);
        ConcurrentHashMap<InternalDistributedMember, PeerEncryptor> m = this.copyOfPeerEncryptors[h];
        if (m != null) return m;
        ConcurrentHashMap<InternalDistributedMember, PeerEncryptor>[] concurrentHashMapArray = this.copyOfPeerEncryptors;
        synchronized (this.copyOfPeerEncryptors) {
            m = this.copyOfPeerEncryptors[h];
            if (m != null) return m;
            this.copyOfPeerEncryptors[h] = m = new ConcurrentHashMap();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClusterEncryptor getClusterEncryptor() {
        int h = Math.abs(Thread.currentThread().getName().hashCode() % numberOfPeerEncryptorCopies);
        ClusterEncryptor c = this.copyOfClusterEncryptors[h];
        if (c != null) return c;
        ClusterEncryptor[] clusterEncryptorArray = this.copyOfClusterEncryptors;
        synchronized (this.copyOfClusterEncryptors) {
            c = this.copyOfClusterEncryptors[h];
            if (c != null) return c;
            this.copyOfClusterEncryptors[h] = c = new ClusterEncryptor(this.getClusterSecretKey());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return c;
        }
    }

    private PeerEncryptor createPeerEncryptor(InternalDistributedMember member, byte[] peerKeyBytes) throws Exception {
        PeerEncryptor result = new PeerEncryptor(peerKeyBytes);
        return result;
    }

    private static int getKeySize(String skAlgo) {
        String algoStr;
        int colIdx = skAlgo.indexOf(58);
        int algoKeySize = 0;
        if (colIdx >= 0) {
            algoStr = skAlgo.substring(0, colIdx);
            algoKeySize = Integer.parseInt(skAlgo.substring(colIdx + 1));
        } else {
            algoStr = skAlgo;
        }
        int keysize = -1;
        if (algoStr.equalsIgnoreCase("DESede")) {
            keysize = 24;
        } else if (algoStr.equalsIgnoreCase("Blowfish")) {
            keysize = algoKeySize > 128 ? algoKeySize / 8 : 16;
        } else if (algoStr.equalsIgnoreCase("AES")) {
            keysize = algoKeySize != 192 && algoKeySize != 256 ? 16 : algoKeySize / 8;
        }
        return keysize;
    }

    private static String getDhAlgoStr(String skAlgo) {
        int colIdx = skAlgo.indexOf(58);
        String algoStr = colIdx >= 0 ? skAlgo.substring(0, colIdx) : skAlgo;
        return algoStr;
    }

    private static int getBlockSize(String skAlgo) {
        int blocksize = -1;
        String algoStr = GMSEncrypt.getDhAlgoStr(skAlgo);
        if (algoStr.equalsIgnoreCase("DESede")) {
            blocksize = 8;
        } else if (algoStr.equalsIgnoreCase("Blowfish")) {
            blocksize = 8;
        } else if (algoStr.equalsIgnoreCase("AES")) {
            blocksize = 16;
        }
        return blocksize;
    }

    public static byte[] encryptBytes(byte[] data, Cipher encrypt) throws Exception {
        return encrypt.doFinal(data);
    }

    public static byte[] decryptBytes(byte[] data, Cipher decrypt) throws Exception {
        byte[] decryptBytes = decrypt.doFinal(data);
        return decryptBytes;
    }

    protected static synchronized Cipher getEncryptCipher(String dhSKAlgo, PrivateKey privateKey, PublicKey peerPublicKey) throws Exception {
        Cipher encrypt;
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(privateKey);
        ka.doPhase(peerPublicKey, true);
        int keysize = GMSEncrypt.getKeySize(dhSKAlgo);
        int blocksize = GMSEncrypt.getBlockSize(dhSKAlgo);
        if (keysize == -1 || blocksize == -1) {
            SecretKey sKey = ka.generateSecret(dhSKAlgo);
            encrypt = Cipher.getInstance(dhSKAlgo);
            encrypt.init(1, sKey);
        } else {
            String dhAlgoStr = GMSEncrypt.getDhAlgoStr(dhSKAlgo);
            byte[] sKeyBytes = ka.generateSecret();
            SecretKeySpec sks = new SecretKeySpec(sKeyBytes, 0, keysize, dhAlgoStr);
            IvParameterSpec ivps = new IvParameterSpec(sKeyBytes, keysize, blocksize);
            encrypt = Cipher.getInstance(dhAlgoStr + "/CBC/PKCS5Padding");
            encrypt.init(1, (Key)sks, ivps);
        }
        return encrypt;
    }

    protected static Cipher getEncryptCipher(String dhSKAlgo, byte[] secretBytes) throws Exception {
        Cipher encrypt = null;
        int keysize = GMSEncrypt.getKeySize(dhSKAlgo);
        int blocksize = GMSEncrypt.getBlockSize(dhSKAlgo);
        if (keysize == -1 || blocksize == -1) {
            SecretKeySpec sks = new SecretKeySpec(secretBytes, dhSKAlgo);
            encrypt = Cipher.getInstance(dhSKAlgo);
            encrypt.init(1, sks);
        } else {
            String dhAlgoStr = GMSEncrypt.getDhAlgoStr(dhSKAlgo);
            SecretKeySpec sks = new SecretKeySpec(secretBytes, 0, keysize, dhAlgoStr);
            IvParameterSpec ivps = new IvParameterSpec(secretBytes, keysize, blocksize);
            encrypt = Cipher.getInstance(dhAlgoStr + "/CBC/PKCS5Padding");
            encrypt.init(1, (Key)sks, ivps);
        }
        return encrypt;
    }

    protected static synchronized Cipher getDecryptCipher(String dhSKAlgo, PrivateKey privateKey, PublicKey publicKey) throws Exception {
        Cipher decrypt;
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(privateKey);
        ka.doPhase(publicKey, true);
        int keysize = GMSEncrypt.getKeySize(dhSKAlgo);
        int blocksize = GMSEncrypt.getBlockSize(dhSKAlgo);
        if (keysize == -1 || blocksize == -1) {
            SecretKey sKey = ka.generateSecret(dhSKAlgo);
            decrypt = Cipher.getInstance(dhSKAlgo);
            decrypt.init(2, sKey);
        } else {
            String algoStr = GMSEncrypt.getDhAlgoStr(dhSKAlgo);
            byte[] sKeyBytes = ka.generateSecret();
            SecretKeySpec sks = new SecretKeySpec(sKeyBytes, 0, keysize, algoStr);
            IvParameterSpec ivps = new IvParameterSpec(sKeyBytes, keysize, blocksize);
            decrypt = Cipher.getInstance(algoStr + "/CBC/PKCS5Padding");
            decrypt.init(2, (Key)sks, ivps);
        }
        return decrypt;
    }

    protected static Cipher getDecryptCipher(String dhSKAlgo, byte[] secretBytes) throws Exception {
        Cipher decrypt = null;
        int keysize = GMSEncrypt.getKeySize(dhSKAlgo);
        int blocksize = GMSEncrypt.getBlockSize(dhSKAlgo);
        if (keysize == -1 || blocksize == -1) {
            SecretKeySpec sks = new SecretKeySpec(secretBytes, dhSKAlgo);
            decrypt = Cipher.getInstance(dhSKAlgo);
            decrypt.init(2, sks);
        } else {
            String algoStr = GMSEncrypt.getDhAlgoStr(dhSKAlgo);
            SecretKeySpec sks = new SecretKeySpec(secretBytes, 0, keysize, algoStr);
            IvParameterSpec ivps = new IvParameterSpec(secretBytes, keysize, blocksize);
            decrypt = Cipher.getInstance(algoStr + "/CBC/PKCS5Padding");
            decrypt.init(2, (Key)sks, ivps);
        }
        return decrypt;
    }

    protected static byte[] generateSecret(String dhSKAlgo, PrivateKey privateKey, PublicKey otherPublicKey) throws Exception {
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(privateKey);
        ka.doPhase(otherPublicKey, true);
        int keysize = GMSEncrypt.getKeySize(dhSKAlgo);
        int blocksize = GMSEncrypt.getBlockSize(dhSKAlgo);
        if (keysize == -1 || blocksize == -1) {
            SecretKey sKey = ka.generateSecret(dhSKAlgo);
            return sKey.getEncoded();
        }
        return ka.generateSecret();
    }

    protected static PublicKey getPublicKey(byte[] publicKeyBytes) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFact = KeyFactory.getInstance("DH");
        return keyFact.generatePublic(x509KeySpec);
    }

    protected static void initEncryptCipher(KeyAgreement ka, List<PublicKey> publicKeys) throws Exception {
        Iterator<PublicKey> itr = publicKeys.iterator();
        while (itr.hasNext()) {
            ka.doPhase(itr.next(), !itr.hasNext());
        }
    }

    static {
        dhP = new BigInteger("135287020639910739997189928970717021771311421882765429190887700940242697307989907008041927806610978529253822307916592536509818186767394634756714063947534092593553024224277712367371302394452615862654308111809029797196494501056604787763641987260783383085570220968104473500348898008043285865193451061481841186553");
        dhG = new BigInteger("130583456807197150961665134075139695376245536366239321690167044250081505657615277976871655435431431908701485776974110415733273525810283593126577393912282416840649805564834470583437473176415335737232689814802018696718110109967325936556664646275595822588612548788965341273697569202082715873518528062345259949959");
        numberOfPeerEncryptorCopies = Integer.getInteger("GMSEncrypt.MAX_ENCRYPTORS", Math.max(Runtime.getRuntime().availableProcessors() * 4, 16));
    }

    protected class ClusterEncryptor {
        byte[] secretBytes;
        Cipher encrypt;
        Cipher decrypt;

        public ClusterEncryptor(GMSEncrypt other) throws Exception {
            GMSEncrypt mine = new GMSEncrypt(other.services);
            this.secretBytes = GMSEncrypt.generateSecret(mine.dhSKAlgo, mine.dhPrivateKey, other.dhPublicKey);
        }

        public ClusterEncryptor(byte[] sb) {
            this.secretBytes = sb;
        }

        public synchronized byte[] encryptBytes(byte[] data) throws Exception {
            String algo = GMSEncrypt.this.dhSKAlgo;
            return GMSEncrypt.encryptBytes(data, this.getEncryptCipher(algo));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Cipher getEncryptCipher(String dhSKAlgo) throws Exception {
            if (this.encrypt == null) {
                ClusterEncryptor clusterEncryptor = this;
                synchronized (clusterEncryptor) {
                    if (this.encrypt == null) {
                        this.encrypt = GMSEncrypt.getEncryptCipher(dhSKAlgo, this.secretBytes);
                    }
                }
            }
            return this.encrypt;
        }

        public synchronized byte[] decryptBytes(byte[] data) throws Exception {
            String algo = GMSEncrypt.this.dhSKAlgo;
            Cipher c = this.getDecryptCipher(algo);
            return GMSEncrypt.decryptBytes(data, c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Cipher getDecryptCipher(String dhSKAlgo) throws Exception {
            if (this.decrypt == null) {
                ClusterEncryptor clusterEncryptor = this;
                synchronized (clusterEncryptor) {
                    if (this.decrypt == null) {
                        this.decrypt = GMSEncrypt.getDecryptCipher(dhSKAlgo, this.secretBytes);
                    }
                }
            }
            return this.decrypt;
        }
    }

    protected class PeerEncryptor {
        private PublicKey peerPublicKey = null;
        private String peerSKAlgo = null;
        private Cipher encrypt;
        private Cipher decrypt = null;

        protected PeerEncryptor(byte[] peerPublicKeyBytes) throws Exception {
            this.peerPublicKey = GMSEncrypt.getPublicKey(peerPublicKeyBytes);
        }

        public synchronized byte[] encryptBytes(byte[] data) throws Exception {
            String algo = null;
            algo = this.peerSKAlgo != null ? this.peerSKAlgo : GMSEncrypt.this.dhSKAlgo;
            return GMSEncrypt.encryptBytes(data, this.getEncryptCipher(algo));
        }

        private Cipher getEncryptCipher(String dhSKAlgo) throws Exception {
            if (this.encrypt == null) {
                this.encrypt = GMSEncrypt.getEncryptCipher(dhSKAlgo, GMSEncrypt.this.dhPrivateKey, this.peerPublicKey);
            }
            return this.encrypt;
        }

        public synchronized byte[] decryptBytes(byte[] data) throws Exception {
            String algo = null;
            algo = this.peerSKAlgo != null ? this.peerSKAlgo : GMSEncrypt.this.dhSKAlgo;
            Cipher c = this.getDecryptCipher(algo, this.peerPublicKey);
            return GMSEncrypt.decryptBytes(data, c);
        }

        private Cipher getDecryptCipher(String dhSKAlgo, PublicKey publicKey) throws Exception {
            if (this.decrypt == null) {
                this.decrypt = GMSEncrypt.getDecryptCipher(dhSKAlgo, GMSEncrypt.this.dhPrivateKey, this.peerPublicKey);
            }
            return this.decrypt;
        }
    }
}

