/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.CancelCriterion;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.ElderState;
import org.apache.geode.distributed.internal.locks.GrantorInfo;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.concurrent.StoppableCondition;
import org.apache.geode.internal.util.concurrent.StoppableReentrantLock;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class GrantorRequestProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    private GrantorInfo result;
    public static final long ELDER_CHANGE_SLEEP = Long.getLong("GrantorRequestProcessor.ELDER_CHANGE_SLEEP", 100L);
    private static final byte GET_OP = 0;
    private static final byte BECOME_OP = 1;
    private static final byte CLEAR_OP = 2;
    private static final byte PEEK_OP = 3;
    private static final byte CLEAR_WITH_LOCKS_OP = 4;
    private static final GrantorInfo CLEAR_COMPLETE = new GrantorInfo(null, 0L, 0, false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean basicStartElderCall(InternalDistributedSystem sys, ElderState es, InternalDistributedMember elder, DLockService dls) {
        GrantorRequestContext grc = sys.getGrantorRequestContext();
        grc.elderLock.lock();
        try {
            block9: {
                block11: {
                    block10: {
                        if (es == null) break block10;
                        if (grc.elderCallsInProgress > 0) {
                            GrantorRequestProcessor.elderSyncWait(sys, elder, dls);
                        }
                        break block9;
                    }
                    if (grc.elderCallsInProgress <= 0) break block11;
                    if (elder == grc.currentElder) {
                        ++grc.elderCallsInProgress;
                        break block9;
                    } else if (elder != null && elder.equals(grc.currentElder)) {
                        ++grc.elderCallsInProgress;
                        break block9;
                    } else {
                        GrantorRequestProcessor.elderSyncWait(sys, elder, dls);
                        boolean bl = false;
                        return bl;
                    }
                }
                grc.currentElder = elder;
                grc.elderCallsInProgress = 1;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            grc.elderLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void readyForElderRecovery(InternalDistributedSystem sys, InternalDistributedMember elderId, DLockService dls) {
        GrantorRequestContext grc = sys.getGrantorRequestContext();
        if (elderId != null) {
            grc.elderLock.lock();
            try {
                if (grc.elderCallsInProgress <= 0 || elderId == grc.currentElder || elderId.equals(grc.currentElder)) return;
                GrantorRequestProcessor.elderSyncWait(sys, elderId, dls);
                return;
            }
            finally {
                grc.elderLock.unlock();
            }
        }
        grc.elderLock.lock();
        try {
            if (grc.elderCallsInProgress <= 0) return;
            GrantorRequestProcessor.elderSyncWait(sys, null, dls);
            return;
        }
        finally {
            grc.elderLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void elderSyncWait(InternalDistributedSystem sys, InternalDistributedMember newElder, DLockService dls) {
        GrantorRequestContext grc = sys.getGrantorRequestContext();
        grc.waitingToChangeElder = true;
        LocalizedMessage message = LocalizedMessage.create(LocalizedStrings.GrantorRequestProcessor_GRANTORREQUESTPROCESSOR_ELDERSYNCWAIT_THE_CURRENT_ELDER_0_IS_WAITING_FOR_THE_NEW_ELDER_1, new Object[]{grc.currentElder, newElder});
        while (grc.waitingToChangeElder) {
            logger.info(LogMarker.DLS, (Message)message);
            boolean interrupted = Thread.interrupted();
            try {
                grc.elderLockCondition.await(sys.getConfig().getMemberTimeout());
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                sys.getCancelCriterion().checkCancelInProgress(ignore);
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
            }
        }
    }

    private static ElderState startElderCall(InternalDistributedSystem sys, DLockService dls, boolean usesElderCollaborationLock) {
        ElderState es = null;
        DM dm = sys.getDistributionManager();
        boolean elderCallStarted = false;
        while (!elderCallStarted) {
            InternalDistributedMember elder;
            block6: {
                dm.throwIfDistributionStopped();
                elder = dm.getElderId();
                Assert.assertTrue(elder != null, "starting an elder call with no valid elder");
                if (dm.getId().equals(elder)) {
                    if (usesElderCollaborationLock) {
                        try {
                            es = dm.getElderState(false, true);
                            break block6;
                        }
                        catch (IllegalStateException e) {
                            continue;
                        }
                    }
                    es = dm.getElderState(false, false);
                } else {
                    es = null;
                }
            }
            elderCallStarted = GrantorRequestProcessor.basicStartElderCall(sys, es, elder, dls);
        }
        return es;
    }

    private static void finishElderCall(GrantorRequestContext grc, ElderState es) {
        if (es == null) {
            grc.elderLock.lock();
            try {
                Assert.assertTrue(grc.elderCallsInProgress > 0);
                --grc.elderCallsInProgress;
                if (grc.elderCallsInProgress == 0) {
                    grc.currentElder = null;
                    if (grc.waitingToChangeElder) {
                        grc.waitingToChangeElder = false;
                        grc.elderLockCondition.signalAll();
                    }
                }
            }
            finally {
                grc.elderLock.unlock();
            }
        }
    }

    public static GrantorInfo getGrantor(DLockService service, int dlsSerialNumber, InternalDistributedSystem sys) {
        return GrantorRequestProcessor.basicOp(-1L, service, dlsSerialNumber, sys, null, (byte)0);
    }

    public static GrantorInfo peekGrantor(DLockService service, InternalDistributedSystem sys) {
        return GrantorRequestProcessor.basicOp(-1L, service, -1, sys, null, (byte)3);
    }

    public static GrantorInfo peekGrantor(String serviceName, InternalDistributedSystem sys) {
        return GrantorRequestProcessor.basicOp(-1L, serviceName, null, -1, sys, null, (byte)3);
    }

    public static GrantorInfo becomeGrantor(DLockService service, int dlsSerialNumber, InternalDistributedMember oldTurk, InternalDistributedSystem sys) {
        return GrantorRequestProcessor.basicOp(-1L, service, dlsSerialNumber, sys, oldTurk, (byte)1);
    }

    public static void clearGrantor(long grantorVersion, DLockService service, int dlsSerialNumber, InternalDistributedSystem sys, boolean withLocks) {
        GrantorRequestProcessor.basicOp(grantorVersion, service, dlsSerialNumber, sys, null, withLocks ? (byte)4 : 2);
    }

    private static GrantorInfo basicOp(long grantorVersion, DLockService service, int dlsSerialNumber, InternalDistributedSystem sys, InternalDistributedMember oldTurk, byte opCode) {
        return GrantorRequestProcessor.basicOp(grantorVersion, service.getName(), service, dlsSerialNumber, sys, oldTurk, opCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GrantorInfo basicOp(long grantorVersion, String serviceName, DLockService service, int dlsSerialNumber, InternalDistributedSystem system, InternalDistributedMember oldTurk, byte opCode) {
        GrantorInfo result = null;
        DM dm = system.getDistributionManager();
        GrantorRequestContext grc = system.getGrantorRequestContext();
        boolean interrupted = false;
        try {
            boolean tryNewElder;
            block17: do {
                boolean usesElderCollaborationLock;
                tryNewElder = false;
                boolean bl = usesElderCollaborationLock = opCode == 0 || opCode == 1;
                if (usesElderCollaborationLock) {
                    Assert.assertTrue(service != null, "Attempting GrantorRequest without instance of DistributedLockService");
                }
                ElderState es = GrantorRequestProcessor.startElderCall(system, service, usesElderCollaborationLock);
                dm.throwIfDistributionStopped();
                try {
                    if (es != null) {
                        switch (opCode) {
                            case 0: {
                                result = es.getGrantor(serviceName, dm.getId(), dlsSerialNumber);
                                continue block17;
                            }
                            case 3: {
                                result = es.peekGrantor(serviceName);
                                continue block17;
                            }
                            case 1: {
                                result = es.becomeGrantor(serviceName, dm.getId(), dlsSerialNumber, oldTurk);
                                continue block17;
                            }
                            case 2: {
                                es.clearGrantor(grantorVersion, serviceName, dlsSerialNumber, dm.getId(), false);
                                result = CLEAR_COMPLETE;
                                continue block17;
                            }
                            case 4: {
                                es.clearGrantor(grantorVersion, serviceName, dlsSerialNumber, dm.getId(), true);
                                result = CLEAR_COMPLETE;
                                continue block17;
                            }
                            default: {
                                throw new IllegalStateException("Unknown opCode " + opCode);
                            }
                        }
                    }
                    GrantorRequestProcessor processor = new GrantorRequestProcessor(system, grc.currentElder);
                    boolean sent = GrantorRequestMessage.send(grantorVersion, dlsSerialNumber, serviceName, grc.currentElder, dm, processor, oldTurk, opCode);
                    if (!sent && logger.isTraceEnabled(LogMarker.DLS)) {
                        logger.trace(LogMarker.DLS, "Unable to communicate with elder {}", (Object)grc.currentElder);
                    }
                    try {
                        processor.waitForRepliesUninterruptibly();
                    }
                    catch (ReplyException e) {
                        e.handleAsUnexpected();
                    }
                    if (processor.result != null) {
                        result = processor.result;
                        continue;
                    }
                    if (!dm.getDistributionManagerIds().contains(grc.currentElder) && dm.getViewMembers().contains(grc.currentElder)) {
                        try {
                            Thread.sleep(ELDER_CHANGE_SLEEP);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            dm.getCancelCriterion().checkCancelInProgress(e);
                        }
                    }
                    if (opCode == 2 || opCode == 4) continue;
                    tryNewElder = true;
                }
                finally {
                    GrantorRequestProcessor.finishElderCall(grc, es);
                }
            } while (tryNewElder);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return result;
    }

    private GrantorRequestProcessor(InternalDistributedSystem system, InternalDistributedMember elder) {
        super(system, elder);
    }

    @Override
    public void process(DistributionMessage msg) {
        if (msg instanceof GrantorInfoReplyMessage) {
            GrantorInfoReplyMessage giMsg = (GrantorInfoReplyMessage)msg;
            this.result = giMsg.getGrantorInfo();
        } else if (msg instanceof ReplyMessage) {
            if (((ReplyMessage)msg).getException() == null) {
                this.result = CLEAR_COMPLETE;
            }
        } else {
            Assert.assertTrue(false, "Expected instance of GrantorInfoReplyMessage or CReplyMessage but got " + msg.getClass());
        }
        super.process(msg);
    }

    public static class GrantorInfoReplyMessage
    extends ReplyMessage {
        private InternalDistributedMember grantor;
        private long elderVersionId;
        private int grantorSerialNumber;
        private boolean needsRecovery;

        public static void send(MessageWithReply reqMsg, DM dm, GrantorInfo gi) {
            GrantorInfoReplyMessage m = new GrantorInfoReplyMessage();
            m.grantor = gi.getId();
            m.needsRecovery = gi.needsRecovery();
            m.elderVersionId = gi.getVersionId();
            m.grantorSerialNumber = gi.getSerialNumber();
            m.processorId = reqMsg.getProcessorId();
            m.setRecipient(reqMsg.getSender());
            dm.putOutgoing(m);
        }

        public GrantorInfo getGrantorInfo() {
            return new GrantorInfo(this.grantor, this.elderVersionId, this.grantorSerialNumber, this.needsRecovery);
        }

        @Override
        public int getDSFID() {
            return 95;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.grantor = (InternalDistributedMember)DataSerializer.readObject(in);
            this.elderVersionId = in.readLong();
            this.grantorSerialNumber = in.readInt();
            this.needsRecovery = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.grantor, out);
            out.writeLong(this.elderVersionId);
            out.writeInt(this.grantorSerialNumber);
            out.writeBoolean(this.needsRecovery);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("GrantorInfoReplyMessage").append("; sender=").append(this.getSender()).append("; processorId=").append(this.processorId).append("; grantor=").append(this.grantor).append("; elderVersionId=").append(this.elderVersionId).append("; grantorSerialNumber=").append(this.grantorSerialNumber).append("; needsRecovery=").append(this.needsRecovery).append(")");
            return buff.toString();
        }
    }

    public static class GrantorRequestMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private long grantorVersion;
        private int dlsSerialNumber;
        private String serviceName;
        private int processorId;
        private byte opCode;
        private InternalDistributedMember oldTurk;

        protected static boolean send(long grantorVersion, int dlsSerialNumber, String serviceName, InternalDistributedMember elder, DM dm, ReplyProcessor21 proc, InternalDistributedMember oldTurk, byte opCode) {
            Set failures;
            GrantorRequestMessage msg = new GrantorRequestMessage();
            msg.grantorVersion = grantorVersion;
            msg.dlsSerialNumber = dlsSerialNumber;
            msg.serviceName = serviceName;
            msg.oldTurk = oldTurk;
            msg.opCode = opCode;
            msg.processorId = proc.getProcessorId();
            msg.setRecipient(elder);
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "GrantorRequestMessage sending {} to {}", (Object)msg, (Object)elder);
            }
            return (failures = dm.putOutgoing(msg)) == null || failures.size() == 0;
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        private void replyGrantorInfo(DM dm, GrantorInfo gi) {
            GrantorInfoReplyMessage.send(this, dm, gi);
        }

        private void replyClear(DM dm) {
            ReplyMessage.send(this.getSender(), this.getProcessorId(), null, (ReplySender)dm);
        }

        @Override
        protected void process(DistributionManager dm) {
            this.basicProcess(dm);
        }

        protected void basicProcess(DM dm) {
            ElderState es = dm.getElderState(true, false);
            switch (this.opCode) {
                case 0: {
                    this.replyGrantorInfo(dm, es.getGrantor(this.serviceName, this.getSender(), this.dlsSerialNumber));
                    break;
                }
                case 3: {
                    this.replyGrantorInfo(dm, es.peekGrantor(this.serviceName));
                    break;
                }
                case 1: {
                    this.replyGrantorInfo(dm, es.becomeGrantor(this.serviceName, this.getSender(), this.dlsSerialNumber, this.oldTurk));
                    break;
                }
                case 2: {
                    es.clearGrantor(this.grantorVersion, this.serviceName, this.dlsSerialNumber, this.getSender(), false);
                    this.replyClear(dm);
                    break;
                }
                case 4: {
                    es.clearGrantor(this.grantorVersion, this.serviceName, this.dlsSerialNumber, this.getSender(), true);
                    this.replyClear(dm);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown opCode " + this.opCode);
                }
            }
        }

        @Override
        public int getDSFID() {
            return 94;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.grantorVersion = in.readLong();
            this.dlsSerialNumber = in.readInt();
            this.serviceName = DataSerializer.readString(in);
            this.processorId = in.readInt();
            this.opCode = in.readByte();
            if (this.opCode == 1) {
                this.oldTurk = (InternalDistributedMember)DataSerializer.readObject(in);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeLong(this.grantorVersion);
            out.writeInt(this.dlsSerialNumber);
            DataSerializer.writeString(this.serviceName, out);
            out.writeInt(this.processorId);
            out.writeByte(this.opCode);
            if (this.opCode == 1) {
                DataSerializer.writeObject(this.oldTurk, out);
            }
        }

        public static String opCodeToString(int opCode) {
            String string = null;
            switch (opCode) {
                case 0: {
                    string = "GET_OP";
                    break;
                }
                case 1: {
                    string = "BECOME_OP";
                    break;
                }
                case 2: {
                    string = "CLEAR_OP";
                    break;
                }
                case 3: {
                    string = "PEEK_OP";
                    break;
                }
                case 4: {
                    string = "CLEAR_WITH_LOCKS_OP";
                    break;
                }
                default: {
                    string = "UNKNOWN:" + String.valueOf(opCode);
                }
            }
            return string;
        }

        @Override
        public String toString() {
            String opCodeString = GrantorRequestMessage.opCodeToString(this.opCode);
            StringBuffer buff = new StringBuffer();
            buff.append("GrantorRequestMessage (service='").append(this.serviceName).append("'; grantorVersion=").append(this.grantorVersion).append("'; dlsSerialNumber=").append(this.dlsSerialNumber).append("'; processorId=").append(this.processorId).append("'; opCode=").append(opCodeString).append("'; oldT=").append(this.oldTurk).append(")");
            return buff.toString();
        }
    }

    public static class GrantorRequestContext {
        final StoppableReentrantLock elderLock;
        final StoppableCondition elderLockCondition;
        InternalDistributedMember currentElder = null;
        int elderCallsInProgress = 0;
        boolean waitingToChangeElder = false;

        public GrantorRequestContext(CancelCriterion cancelCriterion) {
            this.elderLock = new StoppableReentrantLock(cancelCriterion);
            this.elderLockCondition = this.elderLock.newCondition();
        }
    }
}

