/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.locks.DLockGrantor;
import org.apache.geode.distributed.internal.locks.DLockRemoteToken;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.LockGrantorId;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class DLockRecoverGrantorProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    protected static final DefaultMessageProcessor nullServiceProcessor = new DefaultMessageProcessor();
    private DM dm;
    private DLockGrantor newGrantor;
    private volatile boolean error = false;

    static boolean recoverLockGrantor(Set members, DLockService service, DLockGrantor newGrantor, DM dm, InternalDistributedMember elder) {
        DLockRecoverGrantorProcessor processor = new DLockRecoverGrantorProcessor(dm, members, newGrantor);
        DLockRecoverGrantorMessage msg = new DLockRecoverGrantorMessage();
        msg.serviceName = service.getName();
        msg.processorId = processor.getProcessorId();
        msg.grantorVersion = newGrantor.getVersionId();
        msg.grantorSerialNumber = service.getSerialNumber();
        msg.elder = elder;
        HashSet recipients = new HashSet(members);
        recipients.remove(dm.getId());
        if (!recipients.isEmpty()) {
            msg.setRecipients(recipients);
            dm.putOutgoing(msg);
        }
        if (msg.getSender() == null) {
            msg.setSender(dm.getId());
        }
        msg.scheduleMessage(dm);
        try {
            processor.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            e.handleAsUnexpected();
        }
        return !processor.error;
    }

    private DLockRecoverGrantorProcessor(DM dm, Set members, DLockGrantor newGrantor) {
        super(dm, (Collection)members);
        this.dm = dm;
        this.newGrantor = newGrantor;
    }

    @Override
    protected boolean canStopWaiting() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(DistributionMessage msg) {
        try {
            Assert.assertTrue(msg instanceof DLockRecoverGrantorReplyMessage, "DLockRecoverGrantorProcessor is unable to process message of type " + msg.getClass());
            DLockRecoverGrantorReplyMessage reply = (DLockRecoverGrantorReplyMessage)msg;
            switch (reply.replyCode) {
                case 1: {
                    if (logger.isTraceEnabled(LogMarker.DLS)) {
                        logger.trace(LogMarker.DLS, "Failed DLockRecoverGrantorReplyMessage: '{}'", (Object)reply);
                    }
                    this.error = true;
                    return;
                }
                case 0: {
                    if (logger.isTraceEnabled(LogMarker.DLS)) {
                        logger.trace(LogMarker.DLS, "Processing DLockRecoverGrantorReplyMessage: '{}'", (Object)reply);
                    }
                    HashSet<DLockRemoteToken> lockSet = new HashSet<DLockRemoteToken>();
                    DLockRemoteToken[] heldLocks = reply.heldLocks;
                    if (heldLocks.length <= 0) return;
                    for (int i = 0; i < heldLocks.length; ++i) {
                        lockSet.add(heldLocks[i]);
                    }
                    try {
                        this.newGrantor.initializeHeldLocks(msg.getSender(), lockSet);
                        return;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.dm.getCancelCriterion().checkCancelInProgress(e);
                        return;
                    }
                }
                default: {
                    throw new IllegalStateException("Invalid reply.replyCode " + reply.replyCode);
                }
            }
        }
        catch (IllegalStateException e) {
            if (!logger.isTraceEnabled(LogMarker.DLS)) return;
            logger.trace(LogMarker.DLS, "Processing of DLockRecoverGrantorReplyMessage {} resulted in {}", (Object)msg, (Object)e.getMessage(), (Object)e);
            return;
        }
        finally {
            super.process(msg);
        }
    }

    @Override
    protected boolean allowReplyFromSender() {
        return true;
    }

    static class DefaultMessageProcessor
    implements MessageProcessor {
        DefaultMessageProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DM dm, DLockRecoverGrantorMessage msg) {
            DLockRemoteToken[] heldLocks;
            int replyCode;
            ReplyException replyException;
            block17: {
                replyException = null;
                replyCode = 0;
                heldLocks = new DLockRemoteToken[]{};
                try {
                    DLockService svc = DLockService.getInternalServiceNamed(msg.getServiceName());
                    if (svc == null) break block17;
                    replyCode = 0;
                    LockGrantorId lockGrantorId = new LockGrantorId(dm, msg.getSender(), msg.getGrantorVersion(), msg.getGrantorSerialNumber());
                    Set heldLockSet = svc.getLockTokensForRecovery(lockGrantorId);
                    if (heldLockSet == null) {
                        replyCode = 1;
                        break block17;
                    }
                    heldLocks = heldLockSet.toArray(new DLockRemoteToken[heldLockSet.size()]);
                }
                catch (RuntimeException e) {
                    DLockRecoverGrantorReplyMessage replyMsg;
                    try {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DLOCKRECOVERGRANTORPROCESSOR_DLOCKRECOVERGRANTORMESSAGE_PROCESS_THROWABLE), (Throwable)e);
                        replyException = new ReplyException(e);
                        replyMsg = new DLockRecoverGrantorReplyMessage();
                        replyMsg.replyCode = replyCode;
                        replyMsg.heldLocks = heldLocks;
                    }
                    catch (Throwable throwable) {
                        DLockRecoverGrantorReplyMessage replyMsg2 = new DLockRecoverGrantorReplyMessage();
                        replyMsg2.replyCode = replyCode;
                        replyMsg2.heldLocks = heldLocks;
                        replyMsg2.setProcessorId(msg.getProcessorId());
                        replyMsg2.setRecipient(msg.getSender());
                        replyMsg2.setException(replyException);
                        if (msg.getSender().equals(dm.getId())) {
                            if (logger.isTraceEnabled(LogMarker.DLS)) {
                                logger.trace(LogMarker.DLS, "[DLockRecoverGrantorMessage.process] locally process reply");
                            }
                            replyMsg2.setSender(dm.getId());
                            replyMsg2.dmProcess(dm);
                        } else {
                            if (logger.isTraceEnabled(LogMarker.DLS)) {
                                logger.trace(LogMarker.DLS, "[DLockRecoverGrantorMessage.process] send reply");
                            }
                            dm.putOutgoing(replyMsg2);
                        }
                        throw throwable;
                    }
                    replyMsg.setProcessorId(msg.getProcessorId());
                    replyMsg.setRecipient(msg.getSender());
                    replyMsg.setException(replyException);
                    if (msg.getSender().equals(dm.getId())) {
                        if (logger.isTraceEnabled(LogMarker.DLS)) {
                            logger.trace(LogMarker.DLS, "[DLockRecoverGrantorMessage.process] locally process reply");
                        }
                        replyMsg.setSender(dm.getId());
                        replyMsg.dmProcess(dm);
                    } else {
                        if (logger.isTraceEnabled(LogMarker.DLS)) {
                            logger.trace(LogMarker.DLS, "[DLockRecoverGrantorMessage.process] send reply");
                        }
                        dm.putOutgoing(replyMsg);
                    }
                }
            }
            DLockRecoverGrantorReplyMessage replyMsg = new DLockRecoverGrantorReplyMessage();
            replyMsg.replyCode = replyCode;
            replyMsg.heldLocks = heldLocks;
            replyMsg.setProcessorId(msg.getProcessorId());
            replyMsg.setRecipient(msg.getSender());
            replyMsg.setException(replyException);
            if (msg.getSender().equals(dm.getId())) {
                if (logger.isTraceEnabled(LogMarker.DLS)) {
                    logger.trace(LogMarker.DLS, "[DLockRecoverGrantorMessage.process] locally process reply");
                }
                replyMsg.setSender(dm.getId());
                replyMsg.dmProcess(dm);
            } else {
                if (logger.isTraceEnabled(LogMarker.DLS)) {
                    logger.trace(LogMarker.DLS, "[DLockRecoverGrantorMessage.process] send reply");
                }
                dm.putOutgoing(replyMsg);
            }
        }
    }

    public static interface MessageProcessor {
        public void process(DM var1, DLockRecoverGrantorMessage var2);
    }

    public static class DLockRecoverGrantorReplyMessage
    extends ReplyMessage {
        public static final int OK = 0;
        public static final int GRANTOR_DISPUTE = 1;
        protected int replyCode;
        protected DLockRemoteToken[] heldLocks;

        public int getReplyCode() {
            return this.replyCode;
        }

        public void setReplyCode(int replyCode) {
            this.replyCode = replyCode;
        }

        public DLockRemoteToken[] getHeldLocks() {
            return this.heldLocks;
        }

        public void setHeldLocks(DLockRemoteToken[] heldLocks) {
            this.heldLocks = heldLocks;
        }

        @Override
        public int getDSFID() {
            return -71;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.replyCode = in.readByte();
            this.heldLocks = (DLockRemoteToken[])DataSerializer.readObjectArray(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeByte(this.replyCode);
            DataSerializer.writeObjectArray(this.heldLocks, out);
        }

        @Override
        public String toString() {
            String response = null;
            switch (this.replyCode) {
                case 0: {
                    response = "OK";
                    break;
                }
                case 1: {
                    response = "GRANTOR_DISPUTE";
                    break;
                }
                default: {
                    response = String.valueOf(this.replyCode);
                }
            }
            return "DLockRecoverGrantorReplyMessage (processorId=" + this.processorId + "; replyCode=" + this.replyCode + "=" + response + "; heldLocks=" + Arrays.asList(this.heldLocks) + "; sender=" + this.getSender() + ")";
        }
    }

    public static class DLockRecoverGrantorMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        protected String serviceName;
        protected int processorId;
        protected long grantorVersion;
        protected int grantorSerialNumber;
        protected InternalDistributedMember elder;

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        public void setProcessorId(int processorId) {
            this.processorId = processorId;
        }

        public long getGrantorVersion() {
            return this.grantorVersion;
        }

        public int getGrantorSerialNumber() {
            return this.grantorSerialNumber;
        }

        public InternalDistributedMember getElder() {
            return this.elder;
        }

        @Override
        protected void process(DistributionManager dm) {
            this.processMessage(dm);
        }

        protected void scheduleMessage(DM dm) {
            if (dm instanceof DistributionManager) {
                super.scheduleAction((DistributionManager)dm);
            } else {
                this.processMessage(dm);
            }
        }

        protected void processMessage(DM dm) {
            MessageProcessor processor = nullServiceProcessor;
            DLockService svc = DLockService.getInternalServiceNamed(this.serviceName);
            if (svc != null) {
                if (svc.getDLockRecoverGrantorMessageProcessor() == null) {
                    svc.setDLockRecoverGrantorMessageProcessor(new DefaultMessageProcessor());
                }
                processor = svc.getDLockRecoverGrantorMessageProcessor();
            }
            processor.process(dm, this);
        }

        @Override
        public int getDSFID() {
            return -72;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.serviceName = DataSerializer.readString(in);
            this.processorId = in.readInt();
            this.grantorSerialNumber = in.readInt();
            this.grantorVersion = in.readLong();
            this.elder = (InternalDistributedMember)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.serviceName, out);
            out.writeInt(this.processorId);
            out.writeInt(this.grantorSerialNumber);
            out.writeLong(this.grantorVersion);
            DataSerializer.writeObject(this.elder, out);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("DLockRecoverGrantorMessage (service='");
            buff.append(this.serviceName);
            buff.append("'; processorId=");
            buff.append(this.processorId);
            buff.append("'; grantorVersion=");
            buff.append(this.grantorVersion);
            buff.append("'; grantorSerialNumber=");
            buff.append(this.grantorSerialNumber);
            buff.append("'; elder=");
            buff.append(this.elder);
            buff.append(")");
            return buff.toString();
        }
    }
}

