/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.HashSet;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class DistributionConfigSnapshot
extends DistributionConfigImpl {
    private static final long serialVersionUID = 7445728132965092798L;
    private HashSet modifiable = new HashSet(20);

    public DistributionConfigSnapshot(DistributionConfig dc) {
        super(dc);
        String[] attNames = dc.getAttributeNames();
        for (int i = 0; i < attNames.length; ++i) {
            if (!dc.isAttributeModifiable(attNames[i])) continue;
            this.modifiable.add(attNames[i]);
        }
    }

    @Override
    protected String _getUnmodifiableMsg(String attName) {
        return LocalizedStrings.DistributionConfigSnapshot_THE_0_CONFIGURATION_ATTRIBUTE_CAN_NOT_BE_MODIFIED_WHILE_THE_SYSTEM_IS_RUNNING.toLocalizedString(attName);
    }

    @Override
    public boolean isAttributeModifiable(String attName) {
        this.checkAttributeName(attName);
        return this.modifiable.contains(attName);
    }

    @Override
    protected boolean _modifiableDefault() {
        return true;
    }
}

