/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.DistributionLocator;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.net.SocketCreator;

public abstract class Locator {
    protected File logFile;
    protected InetAddress bindAddress;
    protected String hostnameForClients;

    public static Locator startLocator(int port, File logFile) throws IOException {
        return Locator.startLocator(port, logFile, false, null, null, true, true, null);
    }

    public static Locator startLocatorAndDS(int port, File logFile, Properties distributedSystemProperties) throws IOException {
        return Locator.startLocator(port, logFile, null, distributedSystemProperties, true, true, null);
    }

    public static Locator startLocator(int port, File logFile, InetAddress bindAddress) throws IOException {
        return Locator.startLocator(port, logFile, false, bindAddress, null, true, true, null);
    }

    public static Locator startLocatorAndDS(int port, File logFile, InetAddress bindAddress, Properties dsProperties) throws IOException {
        return Locator.startLocator(port, logFile, bindAddress, dsProperties, true, true, null);
    }

    public static Locator startLocatorAndDS(int port, File logFile, InetAddress bindAddress, Properties dsProperties, boolean peerLocator, boolean serverLocator, String hostnameForClients) throws IOException {
        return Locator.startLocator(port, logFile, bindAddress, dsProperties, true, true, hostnameForClients);
    }

    private static Locator startLocator(int port, File logFile, InetAddress bindAddress, Properties dsProperties, boolean peerLocator, boolean serverLocator, String hostnameForClients) throws IOException {
        return InternalLocator.startLocator(port, logFile, null, null, null, bindAddress, true, dsProperties, hostnameForClients);
    }

    private static Locator startLocator(int port, File logFile, boolean startDistributedSystem, InetAddress bindAddress, Properties dsProperties, boolean peerLocator, boolean serverLocator, String hostnameForClients) throws IOException {
        return InternalLocator.startLocator(port, logFile, null, null, null, bindAddress, startDistributedSystem, dsProperties, hostnameForClients);
    }

    public static List<Locator> getLocators() {
        Locator result = Locator.getLocator();
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(result);
    }

    public static Locator getLocator() {
        return InternalLocator.getLocator();
    }

    public static boolean hasLocators() {
        return Locator.hasLocator();
    }

    public static boolean hasLocator() {
        return InternalLocator.hasLocator();
    }

    public abstract Integer getPort();

    public abstract DistributedSystem getDistributedSystem();

    public File getLogFile() {
        return this.logFile;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public String getHostnameForClients() {
        String result = this.hostnameForClients;
        if (result != null && result.equals("")) {
            result = null;
        }
        return result;
    }

    public abstract boolean isPeerLocator();

    public abstract boolean isServerLocator();

    public abstract void stop();

    public String toString() {
        return LocalizedStrings.DistributionLocator_DISTRIBUTION_LOCATOR_ON_0.toLocalizedString(this.asString());
    }

    public String asString() {
        Object ba = this.bindAddress;
        if (ba == null) {
            try {
                ba = SocketCreator.getHostName(SocketCreator.getLocalHost());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        StringBuilder locatorString = new StringBuilder(String.valueOf(ba));
        Integer port = this.getPort();
        if (port != null && port > 0) {
            locatorString.append('[').append(this.getPort()).append(']');
        }
        return locatorString.toString();
    }

    public static void main(String[] args) {
        DistributionLocator.main(args);
    }
}

