/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.server.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;
import org.apache.geode.DataSerializable;
import org.apache.geode.cache.server.ServerLoad;
import org.apache.geode.cache.server.ServerLoadProbeAdapter;
import org.apache.geode.cache.server.ServerMetrics;
import org.apache.geode.internal.cache.xmlcache.Declarable2;

public class ConnectionCountProbe
extends ServerLoadProbeAdapter
implements Declarable2,
DataSerializable {
    private static final long serialVersionUID = -5072528455996471323L;

    @Override
    public ServerLoad getLoad(ServerMetrics metrics) {
        float load = (float)metrics.getConnectionCount() / (float)metrics.getMaxConnections();
        int queueLoad = metrics.getSubscriptionConnectionCount();
        float loadPerConnection = 1.0f / (float)metrics.getMaxConnections();
        return new ServerLoad(load, loadPerConnection, queueLoad, 1.0f);
    }

    @Override
    public Properties getConfig() {
        return new Properties();
    }

    @Override
    public void init(Properties props) {
    }

    public boolean equals(Object other) {
        return other != null && this.getClass().equals(other.getClass());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "ConnectionCountProbe";
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void toData(DataOutput out) throws IOException {
    }
}

