/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.OrderByComparator;
import org.apache.geode.cache.query.internal.StructBag;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.pdx.internal.PdxString;

public class OrderByComparatorUnmapped
extends OrderByComparator {
    private final Map<Object, Object[]> orderByMap;

    public OrderByComparatorUnmapped(List<CompiledSortCriterion> orderByAttrs, ObjectType objType, ExecutionContext context) {
        super(orderByAttrs, objType, context);
        this.orderByMap = objType.isStructType() ? new Object2ObjectOpenCustomHashMap((Hash.Strategy)new StructBag.ObjectArrayFUHashingStrategy()) : new HashMap<Object, Object[]>();
    }

    @Override
    void addEvaluatedSortCriteria(Object row, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        this.orderByMap.put(row, this.calculateSortCriteria(context, row));
    }

    @Override
    public int evaluateSortCriteria(Object obj1, Object obj2) {
        Object[] list2;
        int result = -1;
        Object[] list1 = this.evaluateSortCriteria(obj1);
        if (list1.length != (list2 = this.evaluateSortCriteria(obj2)).length) {
            Support.assertionFailed("Error Occurred due to improper sort criteria evaluation ");
        } else {
            for (int i = 0; i < list1.length; ++i) {
                Object[] arr1 = (Object[])list1[i];
                Object[] arr2 = (Object[])list2[i];
                if (arr1[0] == null || arr2[0] == null) {
                    result = arr1[0] == null ? (arr2[0] == null ? 0 : -1) : 1;
                } else if (arr1[0] == QueryService.UNDEFINED || arr2[0] == QueryService.UNDEFINED) {
                    result = arr1[0] == QueryService.UNDEFINED ? (arr2[0] == QueryService.UNDEFINED ? 0 : -1) : 1;
                } else if (arr1[0] instanceof Number && arr2[0] instanceof Number) {
                    double diff = ((Number)arr1[0]).doubleValue() - ((Number)arr2[0]).doubleValue();
                    result = diff > 0.0 ? 1 : (diff < 0.0 ? -1 : 0);
                } else {
                    if (arr1[0] instanceof PdxString && arr2[0] instanceof String) {
                        arr2[0] = new PdxString((String)arr2[0]);
                    } else if (arr2[0] instanceof PdxString && arr1[0] instanceof String) {
                        arr1[0] = new PdxString((String)arr1[0]);
                    }
                    result = ((Comparable)arr1[0]).compareTo(arr2[0]);
                }
                if (result == 0) continue;
                if (!((Boolean)arr1[1]).booleanValue()) break;
                result *= -1;
                break;
            }
        }
        return result;
    }

    @Override
    protected Object[] evaluateSortCriteria(Object row) {
        return this.orderByMap.get(row);
    }

    private Object[] calculateSortCriteria(ExecutionContext context, Object row) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.orderByAttrs != null) {
            Object[] evaluatedResult = new Object[this.orderByAttrs.size()];
            Iterator orderiter = this.orderByAttrs.iterator();
            int index = 0;
            while (orderiter.hasNext()) {
                CompiledSortCriterion csc = (CompiledSortCriterion)orderiter.next();
                Object[] arr = new Object[]{csc.getColumnIndex() == -1 ? csc.evaluate(context) : csc.evaluate(row, context), csc.getCriterion()};
                evaluatedResult[index++] = arr;
            }
            return evaluatedResult;
        }
        return null;
    }
}

