/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.VMCachedDeserializable;
import org.apache.geode.pdx.internal.PdxString;

public class OrderByComparator
implements Comparator {
    private final ObjectType objType;
    private final ExecutionContext context;
    protected final List<CompiledSortCriterion> orderByAttrs;

    public OrderByComparator(List<CompiledSortCriterion> orderByAttrs, ObjectType objType, ExecutionContext context) {
        this.objType = objType;
        this.context = context;
        this.orderByAttrs = orderByAttrs;
    }

    protected Object[] evaluateSortCriteria(Object value) {
        Object[] array = null;
        if (this.orderByAttrs != null) {
            array = new Object[this.orderByAttrs.size()];
            Iterator<CompiledSortCriterion> orderiter = this.orderByAttrs.iterator();
            int i = 0;
            while (orderiter.hasNext()) {
                CompiledSortCriterion csc = orderiter.next();
                Object[] arr = new Object[]{csc.evaluate(value, this.context), csc.getCriterion()};
                array[i++] = arr;
            }
        }
        return array;
    }

    protected int evaluateSortCriteria(Object value1, Object value2) {
        int result = -1;
        if (this.orderByAttrs != null) {
            for (CompiledSortCriterion csc : this.orderByAttrs) {
                Object sortCriteriaForValue1 = csc.evaluate(value1, this.context);
                Object sortCriteriaForValue2 = csc.evaluate(value2, this.context);
                if (sortCriteriaForValue1 == null || sortCriteriaForValue2 == null) {
                    result = sortCriteriaForValue1 == null ? (sortCriteriaForValue2 == null ? 0 : -1) : 1;
                } else if (sortCriteriaForValue1 == QueryService.UNDEFINED || sortCriteriaForValue2 == QueryService.UNDEFINED) {
                    result = sortCriteriaForValue1 == QueryService.UNDEFINED ? (sortCriteriaForValue2 == QueryService.UNDEFINED ? 0 : -1) : 1;
                } else if (sortCriteriaForValue1 instanceof Number && sortCriteriaForValue2 instanceof Number) {
                    double diff = ((Number)sortCriteriaForValue1).doubleValue() - ((Number)sortCriteriaForValue2).doubleValue();
                    result = diff > 0.0 ? 1 : (diff < 0.0 ? -1 : 0);
                } else {
                    if (sortCriteriaForValue1 instanceof PdxString && sortCriteriaForValue2 instanceof String) {
                        sortCriteriaForValue2 = new PdxString((String)sortCriteriaForValue2);
                    } else if (sortCriteriaForValue2 instanceof PdxString && sortCriteriaForValue1 instanceof String) {
                        sortCriteriaForValue1 = new PdxString((String)sortCriteriaForValue1);
                    }
                    result = ((Comparable)sortCriteriaForValue1).compareTo(sortCriteriaForValue2);
                }
                if (result == 0) continue;
                if (!Boolean.valueOf(csc.getCriterion()).booleanValue()) break;
                result *= -1;
                break;
            }
        }
        return result;
    }

    public int compare(Object obj1, Object obj2) {
        int result = -1;
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        assert (!(obj1 instanceof VMCachedDeserializable) && !(obj2 instanceof VMCachedDeserializable));
        if (this.objType.isStructType() && obj1 instanceof Object[] && obj2 instanceof Object[] || !this.objType.isStructType()) {
            result = this.evaluateSortCriteria(obj1, obj2);
            if (result != 0) {
                return result;
            }
            QueryObserver observer = QueryObserverHolder.getInstance();
            if (observer != null) {
                observer.orderByColumnsEqual();
            }
            if (this.objType.isStructType()) {
                int i = 0;
                for (Object o1 : (Object[])obj1) {
                    Object o2 = ((Object[])obj2)[i++];
                    if (o1 == null || o2 == null) {
                        if (o1 == null) {
                            if (o2 == null) continue;
                            return -1;
                        }
                        return 1;
                    }
                    if (o1 == QueryService.UNDEFINED || o2 == QueryService.UNDEFINED) {
                        if (o1 == QueryService.UNDEFINED) {
                            if (o2 == QueryService.UNDEFINED) continue;
                            return -1;
                        }
                        return 1;
                    }
                    if (o1 instanceof Comparable) {
                        int rslt;
                        if (o1 instanceof Number && o2 instanceof Number) {
                            double diff = ((Number)o1).doubleValue() - ((Number)o2).doubleValue();
                            rslt = diff > 0.0 ? 1 : (diff < 0.0 ? -1 : 0);
                        } else {
                            if (o1 instanceof PdxString && o2 instanceof String) {
                                o2 = new PdxString((String)o2);
                            } else if (o2 instanceof PdxString && o1 instanceof String) {
                                o1 = new PdxString((String)o1);
                            }
                            rslt = ((Comparable)o1).compareTo(o2);
                        }
                        if (rslt == 0) continue;
                        return rslt;
                    }
                    if (o1.equals(o2)) continue;
                    return -1;
                }
                return 0;
            }
            if (obj1 instanceof PdxString && obj2 instanceof String) {
                obj2 = new PdxString((String)obj2);
            } else if (obj2 instanceof PdxString && obj1 instanceof String) {
                obj1 = new PdxString((String)obj1);
            }
            if (obj1 instanceof Comparable) {
                return ((Comparable)obj1).compareTo(obj2);
            }
            return obj1.equals(obj2) ? 0 : -1;
        }
        return -1;
    }

    void addEvaluatedSortCriteria(Object row, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
    }
}

