/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.execute.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.InternalClientCache;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.ProxyRegion;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.MemberFunctionExecutor;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.ServerFunctionExecutor;
import org.apache.geode.internal.cache.execute.ServerRegionFunctionExecutor;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class FunctionServiceManager {
    private static final ConcurrentHashMap<String, Function> idToFunctionMap = new ConcurrentHashMap();
    public static final boolean RANDOM_onMember = Boolean.getBoolean("gemfire.randomizeOnMember");

    public Execution onRegion(Region region) {
        Pool pool;
        if (region == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("Region instance "));
        }
        ProxyCache proxyCache = null;
        String poolName = region.getAttributes().getPoolName();
        if (poolName != null && (pool = PoolManager.find(poolName)).getMultiuserAuthentication()) {
            if (region instanceof ProxyRegion) {
                ProxyRegion proxyRegion = (ProxyRegion)region;
                region = proxyRegion.getRealRegion();
                proxyCache = proxyRegion.getAuthenticatedCache();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        if (this.isClientRegion(region)) {
            return new ServerRegionFunctionExecutor(region, proxyCache);
        }
        if (PartitionRegionHelper.isPartitionedRegion(region)) {
            return new PartitionedRegionFunctionExecutor(region);
        }
        return new DistributedRegionFunctionExecutor(region);
    }

    public Execution onServer(Pool pool, String ... groups) {
        if (pool == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("Pool instance "));
        }
        if (pool.getMultiuserAuthentication()) {
            throw new UnsupportedOperationException();
        }
        return new ServerFunctionExecutor(pool, false, groups);
    }

    public Execution onServers(Pool pool, String ... groups) {
        if (pool == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("Pool instance "));
        }
        if (pool.getMultiuserAuthentication()) {
            throw new UnsupportedOperationException();
        }
        return new ServerFunctionExecutor(pool, true, groups);
    }

    public Execution onServer(RegionService regionService, String ... groups) {
        if (regionService == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("RegionService instance "));
        }
        if (regionService instanceof GemFireCacheImpl) {
            InternalClientCache internalCache = (InternalClientCache)regionService;
            if (!internalCache.isClient()) {
                throw new FunctionException("The cache was not a client cache");
            }
            if (internalCache.getDefaultPool() != null) {
                return this.onServer(internalCache.getDefaultPool(), groups);
            }
            throw new FunctionException("The client cache does not have a default pool");
        }
        ProxyCache proxyCache = (ProxyCache)regionService;
        return new ServerFunctionExecutor(proxyCache.getUserAttributes().getPool(), false, proxyCache, groups);
    }

    public Execution onServers(RegionService regionService, String ... groups) {
        if (regionService == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("RegionService instance "));
        }
        if (regionService instanceof GemFireCacheImpl) {
            InternalClientCache internalCache = (InternalClientCache)regionService;
            if (!internalCache.isClient()) {
                throw new FunctionException("The cache was not a client cache");
            }
            if (internalCache.getDefaultPool() != null) {
                return this.onServers(internalCache.getDefaultPool(), groups);
            }
            throw new FunctionException("The client cache does not have a default pool");
        }
        ProxyCache proxyCache = (ProxyCache)regionService;
        return new ServerFunctionExecutor(proxyCache.getUserAttributes().getPool(), true, proxyCache, groups);
    }

    public Execution onMember(DistributedSystem system, DistributedMember distributedMember) {
        if (system == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("DistributedSystem instance "));
        }
        if (distributedMember == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("DistributedMember instance "));
        }
        return new MemberFunctionExecutor(system, distributedMember);
    }

    public Execution onMembers(DistributedSystem system, String ... groups) {
        if (system == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("DistributedSystem instance "));
        }
        if (groups.length == 0) {
            return new MemberFunctionExecutor(system);
        }
        HashSet<DistributedMember> members = new HashSet<DistributedMember>();
        for (String group : groups) {
            members.addAll(system.getGroupMembers(group));
        }
        if (members.isEmpty()) {
            throw new FunctionException(LocalizedStrings.FunctionService_NO_MEMBERS_FOUND_IN_GROUPS.toLocalizedString(Arrays.toString(groups)));
        }
        return new MemberFunctionExecutor(system, members);
    }

    public Execution onMembers(DistributedSystem system, Set<DistributedMember> distributedMembers) {
        if (system == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("DistributedSystem instance "));
        }
        if (distributedMembers == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("distributedMembers set "));
        }
        return new MemberFunctionExecutor(system, distributedMembers);
    }

    public Function getFunction(String functionId) {
        if (functionId == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("functionId instance "));
        }
        return idToFunctionMap.get(functionId);
    }

    public void registerFunction(Function function) {
        if (function == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("function instance "));
        }
        if (function.getId() == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_GET_ID_RETURNED_NULL.toLocalizedString());
        }
        if (function.isHA() && !function.hasResult()) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH.toLocalizedString());
        }
        idToFunctionMap.put(function.getId(), function);
    }

    public void unregisterFunction(String functionId) {
        if (functionId == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("functionId instance "));
        }
        idToFunctionMap.remove(functionId);
    }

    public boolean isRegistered(String functionId) {
        if (functionId == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("functionId instance "));
        }
        return idToFunctionMap.containsKey(functionId);
    }

    public Map<String, Function> getRegisteredFunctions() {
        HashMap<String, Function> tempIdToFunctionMap = new HashMap<String, Function>();
        for (Map.Entry<String, Function> entry : idToFunctionMap.entrySet()) {
            if (entry.getValue() instanceof InternalEntity) continue;
            tempIdToFunctionMap.put(entry.getKey(), entry.getValue());
        }
        return tempIdToFunctionMap;
    }

    public void unregisterAllFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>(idToFunctionMap);
        for (String functionId : idToFunctionMap.keySet()) {
            this.unregisterFunction(functionId);
        }
    }

    private boolean isClientRegion(Region region) {
        LocalRegion localRegion = (LocalRegion)region;
        return localRegion.hasServerProxy();
    }

    public Execution onMember(DistributedSystem system, String ... groups) {
        if (system == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("DistributedSystem instance "));
        }
        HashSet<DistributedMember> members = new HashSet<DistributedMember>();
        for (String group : groups) {
            ArrayList<DistributedMember> grpMembers = new ArrayList<DistributedMember>(system.getGroupMembers(group));
            if (grpMembers.isEmpty()) continue;
            if (!RANDOM_onMember && grpMembers.contains(system.getDistributedMember())) {
                members.add(system.getDistributedMember());
                continue;
            }
            Collections.shuffle(grpMembers);
            members.add((DistributedMember)grpMembers.get(0));
        }
        if (members.isEmpty()) {
            throw new FunctionException(LocalizedStrings.FunctionService_NO_MEMBERS_FOUND_IN_GROUPS.toLocalizedString(Arrays.toString(groups)));
        }
        return new MemberFunctionExecutor(system, members);
    }
}

