/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.Properties;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;

public class ProxyCacheCloseOp {
    public static Object executeOn(ServerLocation location, ExecutablePool pool, Properties securityProps, boolean keepAlive) {
        ProxyCacheCloseOpImpl op = new ProxyCacheCloseOpImpl(pool, securityProps, keepAlive);
        return pool.executeOn(location, (Op)op);
    }

    private ProxyCacheCloseOp() {
    }

    static class ProxyCacheCloseOpImpl
    extends AbstractOp {
        public ProxyCacheCloseOpImpl(ExecutablePool pool, Properties securityProps, boolean keepAlive) {
            super(78, 1);
            byte[] byArray;
            this.getMessage().setMessageHasSecurePartFlag();
            Message message = this.getMessage();
            if (keepAlive) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            message.addBytesPart(byArray);
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
            byte[] secureBytes = null;
            hdos.writeLong(cnx.getConnectionID());
            Long userId = UserAttributes.userAttributes.get().getServerToId().get(cnx.getServer());
            if (userId == null) {
                throw new ServerConnectivityException("Connection error while authenticating user");
            }
            hdos.writeLong(userId);
            try {
                secureBytes = ((ConnectionImpl)cnx).getHandShake().encryptBytes(hdos.toByteArray());
            }
            finally {
                hdos.close();
            }
            this.getMessage().setSecurePart(secureBytes);
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            Part part = msg.getPart(0);
            int msgType = msg.getMessageType();
            if (msgType == 6) {
                return part.getObject();
            }
            if (msgType == 2) {
                String s = "While performing a remote proxy cache close";
                throw new ServerOperationException(s, (Throwable)part.getObject());
            }
            if (this.isErrorResponse(msgType)) {
                throw new ServerOperationException(part.getString());
            }
            throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 3;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGet();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGet(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

