/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.pdx.internal.EnumInfo;

public class GetPDXIdForEnumOp {
    public static int execute(ExecutablePool pool, EnumInfo ei) {
        GetPDXIdForEnumOpImpl op = new GetPDXIdForEnumOpImpl(ei);
        return (Integer)pool.execute(op);
    }

    private GetPDXIdForEnumOp() {
    }

    private static class GetPDXIdForEnumOpImpl
    extends AbstractOp {
        public GetPDXIdForEnumOpImpl(EnumInfo ei) {
            super(97, 1);
            this.getMessage().addObjPart(ei);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            Part part = msg.getPart(0);
            int msgType = msg.getMessageType();
            if (msgType == 1) {
                return part.getInt();
            }
            if (msgType == 2) {
                String s = "While performing a remote getPdxIdForEnum";
                throw new ServerOperationException(s, (Throwable)part.getObject());
            }
            if (this.isErrorResponse(msgType)) {
                throw new ServerOperationException(part.getString());
            }
            throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGetPDXTypeById();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetPDXTypeByIdSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGetPDXTypeById(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected boolean participateInTransaction() {
            return false;
        }
    }
}

