/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class LossAction
implements Serializable {
    private static final long serialVersionUID = -832035480397447797L;
    public static final LossAction NO_ACCESS = new LossAction("NO_ACCESS");
    public static final LossAction LIMITED_ACCESS = new LossAction("LIMITED_ACCESS");
    public static final LossAction FULL_ACCESS = new LossAction("FULL_ACCESS");
    public static final LossAction RECONNECT = new LossAction("RECONNECT");
    private final transient String name;
    public final byte ordinal;
    private static byte nextOrdinal = 0;
    private static final LossAction[] PRIVATE_VALUES = new LossAction[]{NO_ACCESS, LIMITED_ACCESS, FULL_ACCESS, RECONNECT};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(PRIVATE_VALUES));

    private Object readResolve() throws ObjectStreamException {
        return PRIVATE_VALUES[this.ordinal];
    }

    private LossAction(String name) {
        byte by = nextOrdinal;
        nextOrdinal = (byte)(by + 1);
        this.ordinal = by;
        this.name = name;
    }

    public static LossAction fromOrdinal(byte ordinal) {
        return PRIVATE_VALUES[ordinal];
    }

    public static LossAction fromName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(LocalizedStrings.LossAction_INVALID_LOSSACTION_NAME_0.toLocalizedString(name));
        }
        for (int i = 0; i < PRIVATE_VALUES.length; ++i) {
            if (!name.equals(LossAction.PRIVATE_VALUES[i].name)) continue;
            return PRIVATE_VALUES[i];
        }
        throw new IllegalArgumentException(LocalizedStrings.LossAction_INVALID_LOSSACTION_NAME_0.toLocalizedString(name));
    }

    public boolean isNoAccess() {
        return this == NO_ACCESS;
    }

    public boolean isLimitedAccess() {
        return this == LIMITED_ACCESS;
    }

    public boolean isAllAccess() {
        return this == FULL_ACCESS;
    }

    public boolean isReconnect() {
        return this == RECONNECT;
    }

    public String toString() {
        return this.name;
    }
}

