/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import org.apache.geode.DataSerializable;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.cache.EvictionAttributesImpl;

public abstract class EvictionAttributes
implements DataSerializable {
    public static final int DEFAULT_ENTRIES_MAXIMUM = 900;
    public static final int DEFAULT_MEMORY_MAXIMUM = 10;

    public static EvictionAttributes createLRUEntryAttributes() {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).internalSetMaximum(900);
    }

    public static EvictionAttributes createLRUEntryAttributes(int maximumEntries) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).internalSetMaximum(maximumEntries);
    }

    public static EvictionAttributes createLRUEntryAttributes(EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setAction(evictionAction).internalSetMaximum(900);
    }

    public static EvictionAttributes createLRUEntryAttributes(int maximumEntries, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setAction(evictionAction).internalSetMaximum(maximumEntries);
    }

    public static EvictionAttributes createLRUHeapAttributes() {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_HEAP).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).setObjectSizer(ObjectSizer.DEFAULT);
    }

    public static EvictionAttributes createLRUHeapAttributes(ObjectSizer sizer) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_HEAP).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).setObjectSizer(sizer);
    }

    public static EvictionAttributes createLRUHeapAttributes(ObjectSizer sizer, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_HEAP).setAction(evictionAction).setObjectSizer(sizer);
    }

    public static EvictionAttributes createLRUMemoryAttributes() {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).internalSetMaximum(10).setObjectSizer(ObjectSizer.DEFAULT);
    }

    public static EvictionAttributes createLRUMemoryAttributes(int maximumMegabytes) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).internalSetMaximum(maximumMegabytes).setObjectSizer(null);
    }

    public static EvictionAttributes createLRUMemoryAttributes(int maximumMegabytes, ObjectSizer sizer) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).internalSetMaximum(maximumMegabytes).setObjectSizer(sizer);
    }

    public static EvictionAttributes createLRUMemoryAttributes(int maximumMegabytes, ObjectSizer sizer, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(evictionAction).internalSetMaximum(maximumMegabytes).setObjectSizer(sizer);
    }

    public static EvictionAttributes createLRUMemoryAttributes(ObjectSizer sizer) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).setObjectSizer(sizer).internalSetMaximum(10);
    }

    public static EvictionAttributes createLRUMemoryAttributes(ObjectSizer sizer, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(evictionAction).setObjectSizer(sizer).internalSetMaximum(10);
    }

    public abstract ObjectSizer getObjectSizer();

    public abstract EvictionAlgorithm getAlgorithm();

    public abstract int getMaximum();

    public abstract EvictionAction getAction();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EvictionAttributes)) {
            return false;
        }
        EvictionAttributes other = (EvictionAttributes)obj;
        if (!this.getAlgorithm().equals(other.getAlgorithm()) || !this.getAction().equals(other.getAction())) {
            return false;
        }
        return this.getAlgorithm().isLRUHeap() || this.getMaximum() == other.getMaximum();
    }

    public int hashCode() {
        if (this.getAlgorithm().isLRUHeap()) {
            return this.getAlgorithm().hashCode();
        }
        return this.getAlgorithm().hashCode() ^ this.getMaximum();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(" algorithm=").append(this.getAlgorithm());
        if (!this.getAlgorithm().isNone()) {
            buffer.append("; action=").append(this.getAction());
            if (!this.getAlgorithm().isLRUHeap()) {
                buffer.append("; maximum=").append(this.getMaximum());
            }
            if (this.getObjectSizer() != null) {
                buffer.append("; sizer=").append(this.getObjectSizer());
            }
        }
        return buffer.toString();
    }

    public static EvictionAttributes createLIFOEntryAttributes(int maximumEntries, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LIFO_ENTRY).setAction(evictionAction).internalSetMaximum(maximumEntries);
    }

    public static EvictionAttributes createLIFOMemoryAttributes(int maximumMegabytes, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LIFO_MEMORY).setAction(evictionAction).internalSetMaximum(maximumMegabytes).setObjectSizer(null);
    }
}

