/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.util.List;
import org.apache.geode.CancelException;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.admin.MemberHealthConfig;
import org.apache.geode.admin.internal.AbstractHealthEvaluator;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.statistics.GemFireStatSampler;
import org.apache.geode.internal.statistics.platform.ProcessStats;

class MemberHealthEvaluator
extends AbstractHealthEvaluator {
    private final MemberHealthConfig config;
    private final String description;
    private ProcessStats processStats;
    private final DMStats dmStats;
    private long prevReplyTimeouts;

    MemberHealthEvaluator(GemFireHealthConfig config, DM dm) {
        super(config, dm);
        this.config = config;
        InternalDistributedSystem system = dm.getSystem();
        GemFireStatSampler sampler = system.getStatSampler();
        if (sampler != null) {
            this.processStats = sampler.getProcessStats();
        }
        this.dmStats = dm.getStats();
        StringBuilder sb = new StringBuilder();
        sb.append("Application VM member ");
        sb.append(dm.getId());
        int pid = OSProcess.getId();
        if (pid != 0) {
            sb.append(" with pid ");
            sb.append(pid);
        }
        this.description = sb.toString();
    }

    @Override
    protected String getDescription() {
        return this.description;
    }

    void checkVMProcessSize(List status) {
        long threshold;
        if (this.processStats == null) {
            return;
        }
        long vmSize = this.processStats.getProcessSize();
        if (vmSize > (threshold = this.config.getMaxVMProcessSize())) {
            String s = LocalizedStrings.MemberHealthEvaluator_THE_SIZE_OF_THIS_VM_0_MEGABYTES_EXCEEDS_THE_THRESHOLD_1_MEGABYTES.toLocalizedString(vmSize, threshold);
            status.add(this.okayHealth(s));
        }
    }

    private void checkMessageQueueSize(List status) {
        long threshold = this.config.getMaxMessageQueueSize();
        long overflowSize = this.dmStats.getOverflowQueueSize();
        if (overflowSize > threshold) {
            String s = LocalizedStrings.MemberHealthEvaluator_THE_SIZE_OF_THE_OVERFLOW_QUEUE_0_EXCEEDS_THE_THRESHOLD_1.toLocalizedString(overflowSize, threshold);
            status.add(this.okayHealth(s));
        }
    }

    private void checkReplyTimeouts(List status) {
        if (this.isFirstEvaluation()) {
            return;
        }
        long threshold = this.config.getMaxReplyTimeouts();
        long deltaReplyTimeouts = this.dmStats.getReplyTimeouts() - this.prevReplyTimeouts;
        if (deltaReplyTimeouts > threshold) {
            String s = LocalizedStrings.MemberHealthEvaluator_THE_NUMBER_OF_MESSAGE_REPLY_TIMEOUTS_0_EXCEEDS_THE_THRESHOLD_1.toLocalizedString(deltaReplyTimeouts, threshold);
            status.add(this.okayHealth(s));
        }
    }

    private void checkCacheRequiredRolesMeet(List status) {
        try {
            InternalCache cache = (InternalCache)CacheFactory.getAnyInstance();
            CachePerfStats cPStats = cache.getCachePerfStats();
            if (cPStats.getReliableRegionsMissingFullAccess() > 0) {
                int numRegions = cPStats.getReliableRegionsMissingFullAccess();
                status.add(this.okayHealth(LocalizedStrings.MemberHealthEvaluator_THERE_ARE_0_REGIONS_MISSING_REQUIRED_ROLES_BUT_ARE_CONFIGURED_FOR_FULL_ACCESS.toLocalizedString(numRegions)));
            } else if (cPStats.getReliableRegionsMissingLimitedAccess() > 0) {
                int numRegions = cPStats.getReliableRegionsMissingLimitedAccess();
                status.add(this.poorHealth(LocalizedStrings.MemberHealthEvaluator_THERE_ARE_0_REGIONS_MISSING_REQUIRED_ROLES_AND_CONFIGURED_WITH_LIMITED_ACCESS.toLocalizedString(numRegions)));
            } else if (cPStats.getReliableRegionsMissingNoAccess() > 0) {
                int numRegions = cPStats.getReliableRegionsMissingNoAccess();
                status.add(this.poorHealth(LocalizedStrings.MemberHealthEvaluator_THERE_ARE_0_REGIONS_MISSING_REQUIRED_ROLES_AND_CONFIGURED_WITHOUT_ACCESS.toLocalizedString(numRegions)));
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    private void updatePrevious() {
        this.prevReplyTimeouts = this.dmStats.getReplyTimeouts();
    }

    @Override
    protected void check(List status) {
        this.checkVMProcessSize(status);
        this.checkMessageQueueSize(status);
        this.checkReplyTimeouts(status);
        this.checkCacheRequiredRolesMeet(status);
        this.updatePrevious();
    }

    @Override
    void close() {
    }
}

