/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.util.List;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class AbstractHealthEvaluator {
    private static final Logger logger = LogService.getLogger();
    private int numEvaluations = 0;

    protected AbstractHealthEvaluator(GemFireHealthConfig config, DM dm) {
    }

    public void evaluate(List status) {
        ++this.numEvaluations;
        this.check(status);
    }

    protected abstract void check(List var1);

    protected boolean isFirstEvaluation() {
        return this.numEvaluations <= 1;
    }

    protected HealthStatus okayHealth(String diagnosis) {
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.AbstractHealthEvaluator_OKAY_HEALTH__0, diagnosis));
        return new HealthStatus(GemFireHealth.OKAY_HEALTH, diagnosis);
    }

    protected HealthStatus poorHealth(String diagnosis) {
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.AbstractHealthEvaluator_POOR_HEALTH__0, diagnosis));
        return new HealthStatus(GemFireHealth.POOR_HEALTH, diagnosis);
    }

    protected abstract String getDescription();

    abstract void close();

    public class HealthStatus {
        private GemFireHealth.Health healthCode;
        private String diagnosis;

        HealthStatus(GemFireHealth.Health healthCode, String diagnosis) {
            this.healthCode = healthCode;
            this.diagnosis = "[" + AbstractHealthEvaluator.this.getDescription() + "] " + diagnosis;
        }

        public GemFireHealth.Health getHealthCode() {
            return this.healthCode;
        }

        public String getDiagnosis() {
            return this.diagnosis;
        }
    }
}

