/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core;

import java.util.List;
import java.util.Map;

public class CfApplication {
    private final Map<String, Object> applicationData;

    public CfApplication(Map<String, Object> applicationData) {
        this.applicationData = applicationData;
    }

    public Map<String, Object> getMap() {
        return this.applicationData;
    }

    public String getInstanceId() {
        return this.getString("instance_id");
    }

    public int getInstanceIndex() {
        return this.getInt("instance_index");
    }

    public String getHost() {
        return this.getString("host");
    }

    public int getPort() {
        return this.getInt("port");
    }

    public String getApplicationVersion() {
        return this.getString("application_version");
    }

    public String getApplicationName() {
        return this.getString("application_name");
    }

    public List<String> getApplicationUris() {
        return this.getStringList("application_uris");
    }

    public String getVersion() {
        return this.getString("version");
    }

    public String getName() {
        return this.getString("name");
    }

    public List<String> getUris() {
        return this.getStringList("uris");
    }

    private String getString(String key) {
        if (this.applicationData != null && this.applicationData.containsKey(key)) {
            return this.applicationData.get(key).toString();
        }
        return null;
    }

    private List<String> getStringList(String key) {
        Object value;
        if (this.applicationData != null && this.applicationData.containsKey(key) && (value = this.applicationData.get(key)) instanceof List) {
            return (List)value;
        }
        return null;
    }

    private int getInt(String key) {
        Object intValue;
        if (this.applicationData != null && this.applicationData.containsKey(key) && (intValue = this.applicationData.get(key)) instanceof Integer) {
            return (Integer)intValue;
        }
        return -1;
    }
}

