/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import java.util.Collections;
import java.util.Map;

public class VaultCfEnvProcessor
implements CfEnvProcessor {
    @Override
    public boolean accept(CfService service) {
        return service.existsByLabelStartsWith("hashicorp-vault");
    }

    @Override
    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        properties.put("spring.cloud.vault.uri", cfCredentials.getString(new String[]{"address"}));
        Map auth = cfCredentials.getMap().getOrDefault("auth", Collections.emptyMap());
        properties.put("spring.cloud.vault.token", auth.get("token"));
    }

    @Override
    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("spring.cloud.vault").serviceName("HashiCorp Vault").build();
    }
}

