/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import org.springframework.util.ClassUtils;

public abstract class ConnectorLibraryDetector {
    public static String MESSAGE = "Exiting the application since the Spring Cloud Connector library has been detected on the classpath.  Please remove this dependency from your project and set the environment variable JBP_CONFIG_SPRING_AUTO_RECONFIGURATION '{enabled: false}' in the Cloud Foundry manifest.";
    private static boolean usingConnectorLibrary;

    static boolean isUsingConnectorLibrary() {
        return usingConnectorLibrary;
    }

    static void assertNoConnectorLibrary() {
        if (ConnectorLibraryDetector.isUsingConnectorLibrary()) {
            throw new IllegalStateException(MESSAGE);
        }
    }

    static {
        ClassLoader classLoader = ConnectorLibraryDetector.class.getClassLoader();
        usingConnectorLibrary = ClassUtils.isPresent((String)"org.springframework.cloud.Cloud", (ClassLoader)classLoader) || ClassUtils.isPresent((String)"org.cloudfoundry.reconfiguration.org.springframework.cloud.Cloud", (ClassLoader)classLoader);
    }
}

