/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.tracewriter;

import com.google.gson.annotations.SerializedName;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
final class TraceEvent
implements Cloneable {
    static final TraceEvent EVENT = new TraceEvent();
    @SerializedName(value="ph")
    private String phase;
    @SerializedName(value="name")
    private String name;
    @Nullable
    @SerializedName(value="cat")
    private String categories;
    @Nullable
    @SerializedName(value="ts")
    private Double traceClockMicros;
    @Nullable
    @SerializedName(value="pid")
    private Long pid;
    @SerializedName(value="tid")
    @Nullable
    private Long tid;
    @Nullable
    @SerializedName(value="id")
    private Long id;
    @Nullable
    @SerializedName(value="args")
    private TagMap args = null;
    @Nullable
    @SerializedName(value="cname")
    private String colorName = null;

    private TraceEvent() {
    }

    TraceEvent name(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        TraceEvent other = this.clone();
        other.name = name;
        return other;
    }

    TraceEvent categories(String ... categories) {
        if (categories == null) {
            throw new NullPointerException("categories");
        }
        return this.categories(Arrays.asList(categories));
    }

    TraceEvent categories(List<String> categories) {
        if (categories == null) {
            throw new NullPointerException("categories");
        }
        TraceEvent other = this.clone();
        if (!categories.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            ListIterator<String> it = categories.listIterator();
            sb.append(it.next());
            while (it.hasNext()) {
                String next = it.next();
                if (next == null) {
                    throw new NullPointerException("next null at " + (it.nextIndex() - 1));
                }
                sb.append(',').append(next);
            }
            other.categories = sb.toString();
        } else {
            other.categories = null;
        }
        return other;
    }

    strictfp TraceEvent traceClockNanos(long traceClockNanos) {
        TraceEvent other = this.clone();
        other.traceClockMicros = (double)traceClockNanos / 1000.0;
        return other;
    }

    TraceEvent phase(String phase) {
        if (phase == null) {
            throw new NullPointerException("phase");
        }
        TraceEvent other = this.clone();
        other.phase = phase;
        return other;
    }

    TraceEvent tid(long tid) {
        TraceEvent other = this.clone();
        other.tid = tid;
        return other;
    }

    TraceEvent pid(long pid) {
        TraceEvent other = this.clone();
        other.pid = pid;
        return other;
    }

    TraceEvent id(long id) {
        TraceEvent other = this.clone();
        other.id = id;
        return other;
    }

    TraceEvent args(TagMap tagMap) {
        if (tagMap == null) {
            throw new NullPointerException("tagMap");
        }
        TraceEvent other = this.clone();
        other.args = tagMap;
        return other;
    }

    TagMap args() {
        if (this.args == null) {
            return TagMap.EMPTY;
        }
        return this.args;
    }

    protected TraceEvent clone() {
        try {
            return (TraceEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static final class TagMap
    extends AbstractMap<String, Object> {
        static final TagMap EMPTY = new TagMap(Collections.emptyList(), Collections.emptyList());
        private final List<Map.Entry<String, ?>> keyedValues;
        private final List<?> unkeyedValues;

        private TagMap(List<Map.Entry<String, ?>> keyedValues, List<?> unkeyedValues) {
            this.keyedValues = keyedValues;
            this.unkeyedValues = unkeyedValues;
        }

        TagMap withUnkeyed(@Nullable String tagName, long tagId) {
            ArrayList unkeyedValues = null;
            if (tagName != null && !"".equals(tagName)) {
                unkeyedValues = new ArrayList(this.unkeyedValues);
                unkeyedValues.add(tagName);
            }
            if (tagId != Long.MIN_VALUE) {
                unkeyedValues = unkeyedValues != null ? unkeyedValues : new ArrayList(this.unkeyedValues);
                unkeyedValues.add(tagId);
            }
            if (unkeyedValues != null) {
                return new TagMap(this.keyedValues, Collections.unmodifiableList(unkeyedValues));
            }
            return new TagMap(this.keyedValues, this.unkeyedValues);
        }

        TagMap withKeyed(@Nullable String tagName, Object tagValue) {
            ArrayList keyedValues = new ArrayList(this.keyedValues);
            keyedValues.add(new AbstractMap.SimpleImmutableEntry<String, Object>(String.valueOf(tagName), tagValue));
            return new TagMap(Collections.unmodifiableList(keyedValues), this.unkeyedValues);
        }

        TagMap withKeyed(@Nullable String tagName, long tagValue0, long tagValue1) {
            ArrayList keyedValues = new ArrayList(this.keyedValues);
            keyedValues.add(new AbstractMap.SimpleImmutableEntry<String, String>(String.valueOf(tagName), tagValue0 + ":" + tagValue1));
            return new TagMap(Collections.unmodifiableList(keyedValues), this.unkeyedValues);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            ArrayList<Map.Entry<String, Object>> pairs = new ArrayList<Map.Entry<String, Object>>(this.keyedValues.size() + this.unkeyedValues.size());
            pairs.addAll(this.keyedValues);
            for (Object value : this.unkeyedValues) {
                if (value instanceof Long) {
                    pairs.add(new AbstractMap.SimpleImmutableEntry("id", value));
                    continue;
                }
                if (value instanceof String) {
                    pairs.add(new AbstractMap.SimpleImmutableEntry("tag", value));
                    continue;
                }
                pairs.add(new AbstractMap.SimpleImmutableEntry<String, String>("tag", String.valueOf(value)));
            }
            LinkedHashMap ret = new LinkedHashMap();
            block1: for (Map.Entry entry : pairs) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                String derivedName = name;
                int usages = 0;
                while (true) {
                    if (!ret.containsKey(derivedName)) {
                        ret.put(derivedName, value);
                        continue block1;
                    }
                    if (ret.get(derivedName).equals(value)) continue block1;
                    derivedName = name + " (" + ++usages + ')';
                }
            }
            return Collections.unmodifiableSet(ret.entrySet());
        }
    }
}

