/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.java15;

import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.MarkHolderProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public final class SecretHiddenClassMarkHolderProvider {
    private SecretHiddenClassMarkHolderProvider() {
    }

    public static final class HiddenClassMarkHolderProvider
    extends MarkHolderProvider {
        private static final int DEFAULT_SIZE = 32768;
        private final int[] maxEventsOffsets;
        private final int[] maxEventsMaskOffsets;
        private final byte[] markHolderClassData;

        public HiddenClassMarkHolderProvider() {
            try (InputStream classData = ((Object)((Object)this)).getClass().getResourceAsStream("HiddenClassVarHandleMarkHolder.class");){
                this.markHolderClassData = classData.readAllBytes();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ByteBuffer expectedMaxEvents = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
            expectedMaxEvents.putInt(2117564857);
            byte[] maxEvents = expectedMaxEvents.array();
            this.maxEventsOffsets = HiddenClassMarkHolderProvider.findOffsets(this.markHolderClassData, maxEvents);
            if (this.maxEventsOffsets.length != 2) {
                throw new RuntimeException("hop");
            }
            ByteBuffer expectedMaxEventsMask = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
            expectedMaxEventsMask.putLong(2117564856L);
            byte[] maxEventsMax = expectedMaxEventsMask.array();
            this.maxEventsMaskOffsets = HiddenClassMarkHolderProvider.findOffsets(this.markHolderClassData, maxEventsMax);
            if (this.maxEventsMaskOffsets.length != 1) {
                throw new RuntimeException("skip");
            }
            this.replaceSize(this.markHolderClassData, 32768);
        }

        public MarkHolder create(long markHolderId) {
            return this.create(markHolderId, 32768);
        }

        MarkHolder create(long markHolderId, int size) {
            byte[] classData;
            if (size != 32768) {
                classData = Arrays.copyOf(this.markHolderClassData, this.markHolderClassData.length);
                this.replaceSize(classData, size);
            } else {
                classData = this.markHolderClassData;
            }
            try {
                Class<?> clz = MethodHandles.lookup().defineHiddenClass(classData, true, new MethodHandles.Lookup.ClassOption[0]).lookupClass();
                return clz.asSubclass(MarkHolder.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        private void replaceSize(byte[] haystack, int size) {
            ByteBuffer buf = ByteBuffer.wrap(haystack).order(ByteOrder.BIG_ENDIAN);
            for (int off : this.maxEventsOffsets) {
                buf.putInt(off, size);
            }
            for (int off : this.maxEventsMaskOffsets) {
                buf.putLong(off, size - 1);
            }
        }

        private static int[] findOffsets(byte[] haystack, byte[] needle) {
            int[] matches = new int[]{};
            block0: for (int i = 0; i < haystack.length - needle.length; ++i) {
                for (int k = 0; k < needle.length; ++k) {
                    if (haystack[i + k] != needle[k]) continue block0;
                }
                matches = Arrays.copyOf(matches, matches.length + 1);
                matches[matches.length - 1] = i;
            }
            return matches;
        }
    }
}

