/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.impl.ThreadInfo;
import io.perfmark.impl.ThreadRef;
import io.perfmark.impl.ThreadRefInfo;
import java.util.concurrent.atomic.AtomicLong;

public final class MarkRecorderRef {
    private static final AtomicLong markRecorderAlloc = new AtomicLong(1L);
    private final long markRecorderId;
    private final ThreadInfo threadInfo;

    public static long allocateMarkRecorderId() {
        return markRecorderAlloc.getAndIncrement();
    }

    public static MarkRecorderRef newRef(ThreadInfo threadInfo) {
        return new MarkRecorderRef(markRecorderAlloc.getAndIncrement(), threadInfo);
    }

    public static MarkRecorderRef newRef() {
        ThreadRef threadRef = ThreadRef.newRef(null);
        return new MarkRecorderRef(markRecorderAlloc.getAndIncrement(), new ThreadRefInfo(threadRef));
    }

    private MarkRecorderRef(long markRecorderId, ThreadInfo threadInfo) {
        if (markRecorderId <= 0L) {
            throw new IllegalArgumentException("non-positive markRecorderId");
        }
        this.markRecorderId = markRecorderId;
        if (threadInfo == null) {
            throw new NullPointerException("threadInfo is null");
        }
        this.threadInfo = threadInfo;
    }

    public long markRecorderId() {
        return this.markRecorderId;
    }

    public ThreadInfo threadInfo() {
        return this.threadInfo;
    }

    public int hashCode() {
        return (int)(this.markRecorderId ^ this.markRecorderId >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkRecorderRef that = (MarkRecorderRef)o;
        return this.markRecorderId == that.markRecorderId;
    }

    public String toString() {
        return "MarkRecorderRef[" + this.markRecorderId + ", alive=" + !this.threadInfo().isTerminated() + "]";
    }
}

