/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.extension.core;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.util.List;
import java.util.Map;

public class Nl2brFilter
implements Filter {
    public static final String FILTER_NAME = "nl2br";

    @Override
    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        if (!(input instanceof String)) {
            throw new IllegalArgumentException("nl2br filters only supports String input.");
        }
        String strInput = (String)input;
        if (strInput.indexOf(10) == -1 && strInput.indexOf(13) == -1) {
            return strInput;
        }
        StringBuilder sb = new StringBuilder(strInput.length() + 16);
        return this.convertNewlinesToBr(strInput, sb);
    }

    @Override
    public List<String> getArgumentNames() {
        return null;
    }

    private String convertNewlinesToBr(String input, StringBuilder sb) {
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (c == '\r') {
                sb.append("<br />");
                if (i + 1 >= len || input.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            if (c == '\n') {
                sb.append("<br />");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

