/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class TypeUtils {
    public static Object[] compatibleCast(Object[] argumentValues, Class<?>[] parameterTypes) {
        if (argumentValues == null || parameterTypes == null) {
            return argumentValues;
        }
        Object[] result = new Object[argumentValues.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = TypeUtils.compatibleCast(argumentValues[i], parameterTypes[i]);
        }
        return result;
    }

    public static <T> T compatibleCast(Object value, Class<T> type) {
        if (value == null || type == null || type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (type == Integer.TYPE || type == Integer.class) {
                return (T)Integer.valueOf(number.intValue());
            }
            if (type == Long.TYPE || type == Long.class) {
                return (T)Long.valueOf(number.longValue());
            }
            if (type == Double.TYPE || type == Double.class) {
                return (T)Double.valueOf(number.doubleValue());
            }
            if (type == Float.TYPE || type == Float.class) {
                return (T)Float.valueOf(number.floatValue());
            }
            if (type == Byte.TYPE || type == Byte.class) {
                return (T)Byte.valueOf(number.byteValue());
            }
            if (type == Short.TYPE || type == Short.class) {
                return (T)Short.valueOf(number.shortValue());
            }
            if (type == BigInteger.class) {
                return (T)BigInteger.valueOf(number.longValue());
            }
            if (type == BigDecimal.class) {
                return (T)BigDecimal.valueOf(number.doubleValue());
            }
            if (type == Date.class) {
                return (T)new Date(number.longValue());
            }
            if (type == Boolean.class) {
                return (T)Boolean.valueOf(number.doubleValue() != 0.0);
            }
        }
        if (value instanceof String) {
            String str = (String)value;
            if (type == Boolean.class) {
                return (T)Boolean.valueOf(!str.isEmpty());
            }
        }
        return (T)value;
    }
}

