/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.lexer;

import com.mitchellbosecke.pebble.error.ParserException;
import com.mitchellbosecke.pebble.lexer.Lexer;
import com.mitchellbosecke.pebble.lexer.Syntax;
import com.mitchellbosecke.pebble.lexer.TemplateSource;
import com.mitchellbosecke.pebble.lexer.Token;
import com.mitchellbosecke.pebble.lexer.TokenStream;
import com.mitchellbosecke.pebble.operator.BinaryOperator;
import com.mitchellbosecke.pebble.operator.UnaryOperator;
import com.mitchellbosecke.pebble.utils.Pair;
import com.mitchellbosecke.pebble.utils.StringLengthComparator;
import com.mitchellbosecke.pebble.utils.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LexerImpl
implements Lexer {
    private final Logger logger = LoggerFactory.getLogger(LexerImpl.class);
    private final Syntax syntax;
    private final Collection<UnaryOperator> unaryOperators;
    private final Collection<BinaryOperator> binaryOperators;
    private TemplateSource source;
    private ArrayList<Token> tokens;
    private LinkedList<Pair<String, Integer>> brackets;
    private Deque<State> lexerStateStack = new ArrayDeque<State>();
    private boolean trimLeadingWhitespaceFromNextData = false;
    private static final Pattern REGEX_IDENTIFIER = "The Android Project".equals(System.getProperty("java.vendor")) ? Pattern.compile("^[\\p{Letter}_][\\p{Letter}\\p{Digit}_]*") : Pattern.compile("^[\\p{IsLetter}_][\\p{IsLetter}\\p{IsDigit}_]*");
    private static final Pattern REGEX_LONG = Pattern.compile("^[0-9]+L");
    private static final Pattern REGEX_NUMBER = Pattern.compile("^[0-9]+(\\.[0-9]+)?");
    private static final Pattern REGEX_DOUBLEQUOTE = Pattern.compile("^\"");
    private static final Pattern REGEX_STRING_NON_INTERPOLATED_PART = Pattern.compile("^[^#\"\\\\]*(?:(?:\\\\.|#(?!\\{))[^#\"\\\\]*)*", 32);
    private static final Pattern REGEX_STRING_PLAIN = Pattern.compile("^\"([^#\"\\\\]*(?:\\\\.[^#\"\\\\]*)*)\"|'([^'\\\\]*(?:\\\\.[^'\\\\]*)*)'", 32);
    private static final String PUNCTUATION = "()[]{}?:.,|=";
    private Pattern regexOperators;

    public LexerImpl(Syntax syntax, Collection<UnaryOperator> unaryOperators, Collection<BinaryOperator> binaryOperators) {
        this.syntax = syntax;
        this.unaryOperators = unaryOperators;
        this.binaryOperators = binaryOperators;
    }

    @Override
    public TokenStream tokenize(Reader reader, String name) {
        this.buildOperatorRegex();
        try {
            this.source = new TemplateSource(reader, name);
        }
        catch (IOException e) {
            throw new ParserException((Throwable)e, "Can not convert template Reader into a String", 0, name);
        }
        this.tokens = new ArrayList();
        this.lexerStateStack = new ArrayDeque<State>();
        this.brackets = new LinkedList();
        this.lexerStateStack.push(State.DATA);
        block10: while (this.source.length() > 0) {
            switch (this.lexerStateStack.peek()) {
                case DATA: {
                    this.tokenizeData();
                    continue block10;
                }
                case EXECUTE: {
                    this.tokenizeBetweenExecuteDelimiters();
                    continue block10;
                }
                case PRINT: {
                    this.tokenizeBetweenPrintDelimiters();
                    continue block10;
                }
                case COMMENT: {
                    this.tokenizeComment();
                    continue block10;
                }
                case STRING: {
                    this.tokenizeString();
                    continue block10;
                }
                case STRING_INTERPOLATION: {
                    this.tokenizeStringInterpolation();
                    continue block10;
                }
            }
        }
        this.pushToken(Token.Type.EOF);
        this.popState();
        if (!this.brackets.isEmpty()) {
            String expected = this.brackets.pop().getLeft();
            throw new ParserException(null, String.format("Unclosed \"%s\"", expected), this.source.getLineNumber(), this.source.getFilename());
        }
        return new TokenStream(this.tokens, this.source.getFilename());
    }

    private void tokenizeStringInterpolation() {
        this.logger.trace("Tokenizing String Interpolation");
        String lastBracket = this.brackets.peek().getLeft();
        Matcher matcher = this.syntax.getRegexInterpolationClose().matcher(this.source);
        if (this.syntax.getInterpolationOpenDelimiter().equals(lastBracket) && matcher.lookingAt()) {
            this.brackets.pop();
            this.pushToken(Token.Type.STRING_INTERPOLATION_END);
            this.source.advance(matcher.end());
            this.popState();
        } else {
            this.tokenizeExpression();
        }
    }

    private void tokenizeString() {
        this.logger.trace("Tokenizing String");
        Matcher matcher = this.syntax.getRegexInterpolationOpen().matcher(this.source);
        if (matcher.lookingAt()) {
            this.brackets.push(new Pair<String, Integer>(this.syntax.getInterpolationOpenDelimiter(), this.source.getLineNumber()));
            this.pushToken(Token.Type.STRING_INTERPOLATION_START);
            this.source.advance(matcher.end());
            this.lexerStateStack.push(State.STRING_INTERPOLATION);
            return;
        }
        matcher = REGEX_STRING_NON_INTERPOLATED_PART.matcher(this.source);
        if (matcher.lookingAt() && matcher.end() > 0) {
            String token = this.source.substring(matcher.end());
            this.source.advance(matcher.end());
            this.pushToken(Token.Type.STRING, token);
            return;
        }
        matcher = REGEX_DOUBLEQUOTE.matcher(this.source);
        if (matcher.lookingAt()) {
            String expected = this.brackets.pop().getLeft();
            if (this.source.charAt(0) != '\"') {
                throw new ParserException(null, String.format("Unclosed \"%s\"", expected), this.source.getLineNumber(), this.source.getFilename());
            }
            this.popState();
            this.source.advance(matcher.end());
        }
    }

    private void tokenizeData() {
        String text;
        this.logger.trace("Tokenizing Data");
        Matcher matcher = this.syntax.getRegexStartDelimiters().matcher(this.source);
        boolean match = matcher.find();
        String startDelimiter = null;
        if (!match) {
            this.logger.trace("Advancing to the end of the template because no start delimiter was found");
            text = this.source.toString();
            this.source.advance(this.source.length());
        } else {
            text = this.source.substring(matcher.start());
            startDelimiter = this.source.substring(matcher.start(), matcher.end());
            this.logger.trace("Start Deliminter Token string: {}", (Object)startDelimiter);
            this.source.advance(matcher.end());
        }
        if (this.trimLeadingWhitespaceFromNextData) {
            this.logger.trace("Left Trimming text");
            text = StringUtils.ltrim(text);
            this.trimLeadingWhitespaceFromNextData = false;
        }
        Token textToken = this.pushToken(Token.Type.TEXT, text);
        if (match) {
            this.checkForLeadingWhitespaceTrim(textToken);
            if (this.syntax.getCommentOpenDelimiter().equals(startDelimiter)) {
                this.lexerStateStack.push(State.COMMENT);
            } else if (this.syntax.getPrintOpenDelimiter().equals(startDelimiter)) {
                this.pushToken(Token.Type.PRINT_START);
                this.lexerStateStack.push(State.PRINT);
            } else if (this.syntax.getExecuteOpenDelimiter().equals(startDelimiter)) {
                Matcher verbatimStartMatcher = this.syntax.getRegexVerbatimStart().matcher(this.source);
                if (verbatimStartMatcher.lookingAt()) {
                    this.lexVerbatimData(verbatimStartMatcher);
                    this.lexerStateStack.push(State.DATA);
                } else {
                    this.pushToken(Token.Type.EXECUTE_START);
                    this.lexerStateStack.push(State.EXECUTE);
                }
            }
        }
    }

    private void tokenizeBetweenExecuteDelimiters() {
        this.logger.trace("Tokenize between execute delimiters");
        this.checkForTrailingWhitespaceTrim();
        Matcher matcher = this.syntax.getRegexExecuteClose().matcher(this.source);
        if (this.brackets.isEmpty() && matcher.lookingAt()) {
            this.pushToken(Token.Type.EXECUTE_END, this.syntax.getExecuteCloseDelimiter());
            this.source.advance(matcher.end());
            this.popState();
        } else {
            this.tokenizeExpression();
        }
    }

    private void tokenizeBetweenPrintDelimiters() {
        this.checkForTrailingWhitespaceTrim();
        Matcher matcher = this.syntax.getRegexPrintClose().matcher(this.source);
        if (this.brackets.isEmpty() && matcher.lookingAt()) {
            this.pushToken(Token.Type.PRINT_END, this.syntax.getPrintCloseDelimiter());
            this.source.advance(matcher.end());
            this.popState();
        } else {
            this.tokenizeExpression();
        }
    }

    private void tokenizeComment() {
        Matcher matcher = this.syntax.getRegexCommentClose().matcher(this.source);
        boolean match = matcher.find(0);
        if (!match) {
            throw new ParserException(null, "Unclosed comment.", this.source.getLineNumber(), this.source.getFilename());
        }
        String comment = this.source.substring(matcher.start());
        String reversedComment = new StringBuilder(comment).reverse().toString();
        Matcher whitespaceTrimMatcher = this.syntax.getRegexLeadingWhitespaceTrim().matcher(reversedComment);
        if (whitespaceTrimMatcher.lookingAt()) {
            this.trimLeadingWhitespaceFromNextData = true;
        }
        this.source.advance(matcher.end());
        this.popState();
    }

    private void tokenizeExpression() {
        this.logger.trace("Tokenizing Expression");
        this.source.advanceThroughWhitespace();
        Matcher matcher = this.regexOperators.matcher(this.source);
        if (matcher.lookingAt()) {
            String token = this.source.substring(matcher.end());
            this.pushToken(Token.Type.OPERATOR, token);
            this.source.advance(matcher.end());
            return;
        }
        matcher = REGEX_IDENTIFIER.matcher(this.source);
        if (matcher.lookingAt()) {
            String token = this.source.substring(matcher.end());
            this.pushToken(Token.Type.NAME, token);
            this.source.advance(matcher.end());
            return;
        }
        matcher = REGEX_LONG.matcher(this.source);
        if (matcher.lookingAt()) {
            String token = this.source.substring(matcher.end() - 1);
            this.pushToken(Token.Type.LONG, token);
            this.source.advance(matcher.end());
            return;
        }
        matcher = REGEX_NUMBER.matcher(this.source);
        if (matcher.lookingAt()) {
            String token = this.source.substring(matcher.end());
            this.pushToken(Token.Type.NUMBER, token);
            this.source.advance(matcher.end());
            return;
        }
        if (PUNCTUATION.indexOf(this.source.charAt(0)) >= 0) {
            String character = String.valueOf(this.source.charAt(0));
            if ("([{".contains(character)) {
                this.brackets.push(new Pair<String, Integer>(character, this.source.getLineNumber()));
            } else if (")]}".contains(character)) {
                if (this.brackets.isEmpty()) {
                    throw new ParserException(null, "Unexpected \"" + character + "\"", this.source.getLineNumber(), this.source.getFilename());
                }
                HashMap<String, String> validPairs = new HashMap<String, String>();
                validPairs.put("(", ")");
                validPairs.put("[", "]");
                validPairs.put("{", "}");
                String lastBracket = this.brackets.pop().getLeft();
                String expected = (String)validPairs.get(lastBracket);
                if (!expected.equals(character)) {
                    throw new ParserException(null, "Unclosed \"" + expected + "\"", this.source.getLineNumber(), this.source.getFilename());
                }
            }
            this.pushToken(Token.Type.PUNCTUATION, character);
            this.source.advance(1);
            return;
        }
        matcher = REGEX_STRING_PLAIN.matcher(this.source);
        if (matcher.lookingAt()) {
            String token = this.source.substring(matcher.end());
            this.source.advance(matcher.end());
            token = this.unquoteAndUnescape(token);
            this.pushToken(Token.Type.STRING, token);
            return;
        }
        matcher = REGEX_DOUBLEQUOTE.matcher(this.source);
        if (matcher.lookingAt()) {
            this.brackets.push(new Pair<String, Integer>("\"", this.source.getLineNumber()));
            this.lexerStateStack.push(State.STRING);
            this.source.advance(matcher.end());
            return;
        }
        throw new ParserException(null, String.format("Unexpected character [%s]", Character.valueOf(this.source.charAt(0))), this.source.getLineNumber(), this.source.getFilename());
    }

    private String unquoteAndUnescape(String str) {
        char quotationType = str.charAt(0);
        str = str.substring(1, str.length() - 1);
        if (quotationType == '\'') {
            str = str.replaceAll("\\\\(')", "$1");
        } else if (quotationType == '\"') {
            str = str.replaceAll("\\\\(\")", "$1");
        }
        return str;
    }

    private void checkForLeadingWhitespaceTrim(Token leadingToken) {
        Matcher whitespaceTrimMatcher = this.syntax.getRegexLeadingWhitespaceTrim().matcher(this.source);
        if (whitespaceTrimMatcher.lookingAt()) {
            this.logger.trace("Found Leading Whitespace Trim Character");
            if (leadingToken != null) {
                this.logger.trace("Right trimming leading token: {}", (Object)leadingToken);
                leadingToken.setValue(StringUtils.rtrim(leadingToken.getValue()));
            }
            this.source.advance(whitespaceTrimMatcher.end());
        }
    }

    private void checkForTrailingWhitespaceTrim() {
        Matcher whitespaceTrimMatcher = this.syntax.getRegexTrailingWhitespaceTrim().matcher(this.source);
        if (whitespaceTrimMatcher.lookingAt()) {
            this.trimLeadingWhitespaceFromNextData = true;
        }
    }

    private void lexVerbatimData(Matcher verbatimStartMatcher) {
        this.source.advance(verbatimStartMatcher.end());
        Matcher verbatimEndMatcher = this.syntax.getRegexVerbatimEnd().matcher(this.source);
        if (!verbatimEndMatcher.find()) {
            throw new ParserException(null, "Unclosed verbatim tag.", this.source.getLineNumber(), this.source.getFilename());
        }
        String verbatimText = this.source.substring(verbatimEndMatcher.start());
        if (verbatimStartMatcher.group(0) != null) {
            verbatimText = StringUtils.ltrim(verbatimText);
        }
        if (verbatimEndMatcher.group(1) != null) {
            verbatimText = StringUtils.rtrim(verbatimText);
        }
        if (verbatimEndMatcher.group(2) != null) {
            this.trimLeadingWhitespaceFromNextData = true;
        }
        this.source.advance(verbatimEndMatcher.end());
        this.pushToken(Token.Type.TEXT, verbatimText);
    }

    private Token pushToken(Token.Type type) {
        Token token = this.pushToken(type, null);
        return token;
    }

    private Token pushToken(Token.Type type, String value) {
        if (type.equals((Object)Token.Type.TEXT) && (value == null || "".equals(value))) {
            this.logger.trace("Skipping empty text token");
            return null;
        }
        Token token = new Token(type, value, this.source.getLineNumber());
        this.tokens.add(token);
        this.logger.trace("Pushing Token: {}", (Object)token);
        return token;
    }

    private void popState() {
        this.lexerStateStack.pop();
    }

    private void buildOperatorRegex() {
        ArrayList<String> operators = new ArrayList<String>();
        for (UnaryOperator unaryOperator : this.unaryOperators) {
            operators.add(unaryOperator.getSymbol());
        }
        for (BinaryOperator binaryOperator : this.binaryOperators) {
            operators.add(binaryOperator.getSymbol());
        }
        operators.sort(StringLengthComparator.INSTANCE);
        StringBuilder regex = new StringBuilder("^");
        boolean bl = true;
        for (String operator : operators) {
            boolean bl2;
            if (bl2) {
                bl2 = false;
            } else {
                regex.append("|");
            }
            regex.append(Pattern.quote(operator));
            char nextChar = operator.charAt(operator.length() - 1);
            if (!Character.isLetter(nextChar) && Character.getType(nextChar) != 10) continue;
            regex.append("(?![a-zA-Z0-9_])");
        }
        this.regexOperators = Pattern.compile(regex.toString());
    }

    private static enum State {
        DATA,
        EXECUTE,
        PRINT,
        COMMENT,
        STRING,
        STRING_INTERPOLATION;

    }
}

