/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node;

import com.github.benmanes.caffeine.cache.Cache;
import com.mitchellbosecke.pebble.cache.CacheKey;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.AbstractRenderableNode;
import com.mitchellbosecke.pebble.node.BodyNode;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.template.EvaluationContextImpl;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.concurrent.CompletionException;

public class CacheNode
extends AbstractRenderableNode {
    private final BodyNode body;
    private final Expression<?> name;

    public CacheNode(int lineNumber, Expression<?> name, BodyNode body) {
        super(lineNumber);
        this.body = body;
        this.name = name;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContextImpl context) throws IOException {
        try {
            String body;
            Cache<CacheKey, Object> tagCache = context.getTagCache();
            if (Objects.isNull(tagCache)) {
                body = this.render(self, context);
            } else {
                CacheKey key = new CacheKey(this, (String)this.name.evaluate(self, context), context.getLocale());
                body = (String)context.getTagCache().get((Object)key, k -> {
                    try {
                        return this.render(self, context);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            writer.write(body);
        }
        catch (CompletionException e) {
            throw new PebbleException(e, "Could not render cache block [" + this.name + "]");
        }
    }

    private String render(PebbleTemplateImpl self, EvaluationContextImpl context) throws IOException {
        StringWriter tempWriter = new StringWriter();
        this.body.render(self, tempWriter, context);
        return tempWriter.toString();
    }
}

