/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node.expression;

import com.mitchellbosecke.pebble.error.AttributeNotFoundException;
import com.mitchellbosecke.pebble.error.ClassAccessException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.error.RootAttributeNotFoundException;
import com.mitchellbosecke.pebble.extension.DynamicAttributeProvider;
import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.node.PositionalArgumentNode;
import com.mitchellbosecke.pebble.node.expression.ContextVariableExpression;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GetAttributeExpression
implements Expression<Object> {
    private final Expression<?> node;
    private final Expression<?> attributeNameExpression;
    private final ArgumentsNode args;
    private final String filename;
    private final int lineNumber;
    private final ConcurrentHashMap<MemberCacheKey, Member> memberCache;

    public GetAttributeExpression(Expression<?> node, Expression<?> attributeNameExpression, String filename, int lineNumber) {
        this(node, attributeNameExpression, null, filename, lineNumber);
    }

    public GetAttributeExpression(Expression<?> node, Expression<?> attributeNameExpression, ArgumentsNode args, String filename, int lineNumber) {
        this.node = node;
        this.attributeNameExpression = attributeNameExpression;
        this.args = args;
        this.filename = filename;
        this.lineNumber = lineNumber;
        this.memberCache = new ConcurrentHashMap(2, 0.9f, 1);
    }

    @Override
    public Object evaluate(PebbleTemplateImpl self, EvaluationContext context) {
        Member member;
        Object object = this.node.evaluate(self, context);
        Object attributeNameValue = this.attributeNameExpression.evaluate(self, context);
        String attributeName = String.valueOf(attributeNameValue);
        Object result = null;
        Object[] argumentValues = this.getArgumentValues(self, context);
        Member member2 = member = object == null ? null : this.memberCache.get(new MemberCacheKey(object.getClass(), attributeName));
        if (object != null && member == null) {
            DynamicAttributeProvider dynamicAttributeProvider;
            if (this.args == null) {
                if (object instanceof Map) {
                    return this.getObjectFromMap((Map)object, attributeNameValue);
                }
                try {
                    if (object.getClass().isArray()) {
                        int index = Integer.parseInt(attributeName);
                        int length = Array.getLength(object);
                        if (index < 0 || index >= length) {
                            if (context.isStrictVariables()) {
                                throw new AttributeNotFoundException(null, "Index out of bounds while accessing array with strict variables on.", attributeName, this.lineNumber, this.filename);
                            }
                            return null;
                        }
                        return Array.get(object, index);
                    }
                    if (object instanceof List) {
                        List list = (List)object;
                        int index = Integer.parseInt(attributeName);
                        int length = list.size();
                        if (index < 0 || index >= length) {
                            if (context.isStrictVariables()) {
                                throw new AttributeNotFoundException(null, "Index out of bounds while accessing array with strict variables on.", attributeName, this.lineNumber, this.filename);
                            }
                            return null;
                        }
                        return list.get(index);
                    }
                }
                catch (NumberFormatException list) {
                    // empty catch block
                }
            }
            if (object instanceof DynamicAttributeProvider && (dynamicAttributeProvider = (DynamicAttributeProvider)object).canProvideDynamicAttribute(attributeName)) {
                return dynamicAttributeProvider.getDynamicAttribute(attributeNameValue, argumentValues);
            }
            Class[] argumentTypes = new Class[argumentValues.length];
            for (int i = 0; i < argumentValues.length; ++i) {
                Object o = argumentValues[i];
                argumentTypes[i] = o == null ? null : o.getClass();
            }
            member = this.reflect(object, attributeName, argumentTypes, context.isAllowGetClass());
            if (member != null) {
                this.memberCache.put(new MemberCacheKey(object.getClass(), attributeName), member);
            }
        }
        if (object != null && member != null) {
            result = this.invokeMember(object, member, argumentValues);
        } else if (context.isStrictVariables()) {
            if (object == null) {
                if (this.node instanceof ContextVariableExpression) {
                    String rootPropertyName = ((ContextVariableExpression)this.node).getName();
                    throw new RootAttributeNotFoundException(null, String.format("Root attribute [%s] does not exist or can not be accessed and strict variables is set to true.", rootPropertyName), rootPropertyName, this.lineNumber, this.filename);
                }
                throw new RootAttributeNotFoundException(null, "Attempt to get attribute of null object and strict variables is set to true.", attributeName, this.lineNumber, this.filename);
            }
            if (attributeName.equals("class") || attributeName.equals("getClass")) {
                throw new ClassAccessException(this.lineNumber, this.filename);
            }
            throw new AttributeNotFoundException(null, String.format("Attribute [%s] of [%s] does not exist or can not be accessed and strict variables is set to true.", attributeName, object.getClass().getName()), attributeName, this.lineNumber, this.filename);
        }
        return result;
    }

    private Object getObjectFromMap(Map<?, ?> object, Object attributeNameValue) {
        if (object.isEmpty()) {
            return null;
        }
        if (attributeNameValue != null && Number.class.isAssignableFrom(attributeNameValue.getClass())) {
            Number keyAsNumber = (Number)attributeNameValue;
            Class<?> keyClass = object.keySet().iterator().next().getClass();
            Object key = this.cast(keyAsNumber, keyClass);
            return object.get(key);
        }
        return object.get(attributeNameValue);
    }

    private Object cast(Number number, Class<?> desiredType) {
        if (desiredType == Long.class) {
            return number.longValue();
        }
        if (desiredType == Integer.class) {
            return number.intValue();
        }
        if (desiredType == Double.class) {
            return number.doubleValue();
        }
        if (desiredType == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        if (desiredType == Short.class) {
            return number.shortValue();
        }
        if (desiredType == Byte.class) {
            return number.byteValue();
        }
        throw new PebbleException(null, String.format("type %s not supported for key %s", desiredType, number), this.getLineNumber(), this.filename);
    }

    private Object invokeMember(Object object, Member member, Object[] argumentValues) {
        Object result = null;
        try {
            if (member instanceof Method) {
                result = ((Method)member).invoke(object, argumentValues);
            } else if (member instanceof Field) {
                result = ((Field)member).get(object);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private Object[] getArgumentValues(PebbleTemplateImpl self, EvaluationContext context) {
        Object[] argumentValues;
        if (this.args == null) {
            argumentValues = new Object[]{};
        } else {
            List<PositionalArgumentNode> args = this.args.getPositionalArgs();
            argumentValues = new Object[args.size()];
            int index = 0;
            for (PositionalArgumentNode arg : args) {
                Object argumentValue = arg.getValueExpression().evaluate(self, context);
                argumentValues[index] = argumentValue;
                ++index;
            }
        }
        return argumentValues;
    }

    private Member reflect(Object object, String attributeName, Class<?>[] parameterTypes, boolean allowGetClass) {
        Class<?> clazz = object.getClass();
        AccessibleObject result = null;
        String attributeCapitalized = Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1);
        result = this.findMethod(clazz, "get" + attributeCapitalized, parameterTypes, allowGetClass);
        if (result == null) {
            result = this.findMethod(clazz, "is" + attributeCapitalized, parameterTypes, allowGetClass);
        }
        if (result == null) {
            result = this.findMethod(clazz, "has" + attributeCapitalized, parameterTypes, allowGetClass);
        }
        if (result == null) {
            result = this.findMethod(clazz, attributeName, parameterTypes, allowGetClass);
        }
        if (result == null) {
            try {
                result = clazz.getField(attributeName);
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        if (result != null) {
            ((AccessibleObject)result).setAccessible(true);
        }
        return result;
    }

    private Method findMethod(Class<?> clazz, String name, Class<?>[] requiredTypes, boolean allowGetClass) {
        Method[] candidates;
        if (name.equals("getClass")) {
            if (!allowGetClass) {
                throw new ClassAccessException(this.lineNumber, this.filename);
            }
            return null;
        }
        Method result = null;
        for (Method candidate : candidates = clazz.getMethods()) {
            Class<?>[] types;
            if (!candidate.getName().equalsIgnoreCase(name) || (types = candidate.getParameterTypes()).length != requiredTypes.length) continue;
            boolean compatibleTypes = true;
            for (int i = 0; i < types.length; ++i) {
                if (requiredTypes[i] == null || this.widen(types[i]).isAssignableFrom(requiredTypes[i])) continue;
                compatibleTypes = false;
                break;
            }
            if (!compatibleTypes) continue;
            result = candidate;
            break;
        }
        return result;
    }

    private Class<?> widen(Class<?> clazz) {
        Class<Object> result = clazz;
        if (clazz == Integer.TYPE) {
            result = Integer.class;
        } else if (clazz == Long.TYPE) {
            result = Long.class;
        } else if (clazz == Double.TYPE) {
            result = Double.class;
        } else if (clazz == Float.TYPE) {
            result = Float.class;
        } else if (clazz == Short.TYPE) {
            result = Short.class;
        } else if (clazz == Byte.TYPE) {
            result = Byte.class;
        } else if (clazz == Boolean.TYPE) {
            result = Boolean.class;
        }
        return result;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public Expression<?> getNode() {
        return this.node;
    }

    public Expression<?> getAttributeNameExpression() {
        return this.attributeNameExpression;
    }

    public ArgumentsNode getArgumentsNode() {
        return this.args;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    private class MemberCacheKey {
        private final Class<?> clazz;
        private final String attributeName;

        private MemberCacheKey(Class<?> clazz, String attributeName) {
            this.clazz = clazz;
            this.attributeName = attributeName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberCacheKey that = (MemberCacheKey)o;
            if (!this.clazz.equals(that.clazz)) {
                return false;
            }
            return this.attributeName.equals(that.attributeName);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.attributeName.hashCode();
            return result;
        }
    }
}

