/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.spring.extension.function.bindingresult;

import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import io.pebbletemplates.spring.extension.function.bindingresult.BaseBindingResultFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public class GetFieldErrorsFunction
extends BaseBindingResultFunction {
    public static final String FUNCTION_NAME = "getFieldErrors";
    private final MessageSource messageSource;

    public GetFieldErrorsFunction(MessageSource messageSource) {
        super("formName", "fieldName");
        this.messageSource = messageSource;
    }

    public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
        String formName = (String)args.get("formName");
        String field = (String)args.get("fieldName");
        if (field == null) {
            throw new IllegalArgumentException("Field parameter is required in GetFieldErrorsFunction");
        }
        Locale locale = context.getLocale();
        BindingResult bindingResult = this.getBindingResult(formName, context);
        return this.constructErrorMessages(field, locale, bindingResult);
    }

    private List<String> constructErrorMessages(String field, Locale locale, BindingResult bindingResult) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (bindingResult != null) {
            for (FieldError error : bindingResult.getFieldErrors(field)) {
                String msg = this.messageSource.getMessage((MessageSourceResolvable)error, locale);
                errorMessages.add(msg);
            }
        }
        return errorMessages;
    }
}

