/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.boot.autoconfigure;

import io.pebbletemplates.boot.autoconfigure.AbstractPebbleConfiguration;
import io.pebbletemplates.boot.autoconfigure.PebbleProperties;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.loader.ClasspathLoader;
import io.pebbletemplates.spring.servlet.PebbleViewResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class PebbleServletWebConfiguration
extends AbstractPebbleConfiguration {
    PebbleServletWebConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(name={"pebbleViewResolver"})
    PebbleViewResolver pebbleViewResolver(PebbleProperties properties, PebbleEngine pebbleEngine) {
        PebbleViewResolver pvr = new PebbleViewResolver(pebbleEngine);
        String prefix = properties.getPrefix();
        if (pebbleEngine.getLoader() instanceof ClasspathLoader) {
            prefix = this.stripLeadingSlash(properties.getPrefix());
        }
        pvr.setPrefix(prefix);
        pvr.setSuffix(properties.getSuffix());
        pvr.setCache(properties.getServlet().isCache());
        if (properties.getServlet().getContentType() != null) {
            pvr.setContentType(properties.getServlet().getContentType().toString());
        }
        pvr.setViewNames(properties.getViewNames());
        pvr.setExposeRequestAttributes(properties.getServlet().isExposeRequestAttributes());
        pvr.setAllowRequestOverride(properties.getServlet().isAllowRequestOverride());
        pvr.setAllowSessionOverride(properties.getServlet().isAllowSessionOverride());
        pvr.setExposeSessionAttributes(properties.getServlet().isExposeSessionAttributes());
        pvr.setExposeSpringMacroHelpers(properties.getServlet().isExposeSpringMacroHelpers());
        pvr.setRequestContextAttribute(properties.getRequestContextAttribute());
        pvr.setCharacterEncoding(properties.getCharsetName());
        pvr.setOrder(0x7FFFFFF5);
        return pvr;
    }
}

