/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava3;

import io.opentracing.Tracer;
import io.opentracing.rxjava3.RxTracer;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;

public class TracingObserver<T>
implements Observer<T>,
Disposable {
    private Disposable upstream;
    private final RxTracer rxTracer;
    private final Observer<T> observer;

    public TracingObserver(Observer<T> observer, String operationName, Tracer tracer) {
        this.rxTracer = new RxTracer(operationName, tracer);
        this.observer = observer;
    }

    public void dispose() {
        this.upstream.dispose();
    }

    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    public void onSubscribe(Disposable d) {
        this.upstream = d;
        try {
            this.observer.onSubscribe((Disposable)this);
        }
        finally {
            this.rxTracer.onSubscribe();
        }
    }

    public void onNext(T o) {
        this.observer.onNext(o);
    }

    public void onError(Throwable t) {
        try {
            this.observer.onError(t);
        }
        finally {
            this.rxTracer.onError(t);
        }
    }

    public void onComplete() {
        try {
            this.observer.onComplete();
        }
        finally {
            this.rxTracer.onComplete();
        }
    }
}

