/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava2;

import io.opentracing.Tracer;
import io.opentracing.rxjava2.AbstractTracingObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.observers.LambdaObserver;

public class TracingConsumer<T>
extends AbstractTracingObserver<T>
implements Disposable {
    private final LambdaObserver<T> lambdaObserver;

    public TracingConsumer(String operationName, Tracer tracer) {
        this(Functions.emptyConsumer(), operationName, tracer);
    }

    public TracingConsumer(Consumer<? super T> onNext, String operationName, Tracer tracer) {
        this(onNext, (Consumer<? super Throwable>)Functions.ON_ERROR_MISSING, operationName, tracer);
    }

    public TracingConsumer(Consumer<? super T> onNext, Consumer<? super Throwable> onError, String operationName, Tracer tracer) {
        this(onNext, onError, Functions.EMPTY_ACTION, operationName, tracer);
    }

    public TracingConsumer(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, String operationName, Tracer tracer) {
        this(onNext, onError, onComplete, (Consumer<? super Disposable>)Functions.emptyConsumer(), operationName, tracer);
    }

    public TracingConsumer(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Consumer<? super Disposable> onSubscribe, String operationName, Tracer tracer) {
        super(operationName, tracer);
        TracingConsumer.requireNonNull(onNext, "onNext can not be null");
        TracingConsumer.requireNonNull(onError, "onError can not be null");
        TracingConsumer.requireNonNull(onComplete, "onComplete can not be null");
        TracingConsumer.requireNonNull(onSubscribe, "onSubscribe can not be null");
        TracingConsumer.requireNonNull(tracer, "tracer can not be null");
        this.lambdaObserver = new LambdaObserver(onNext, onError, onComplete, onSubscribe);
    }

    @Override
    public void onSubscribe(Disposable d) {
        try {
            this.lambdaObserver.onSubscribe(d);
        }
        finally {
            super.onSubscribe(d);
        }
    }

    @Override
    public void onNext(T t) {
        this.lambdaObserver.onNext(t);
    }

    @Override
    public void onError(Throwable t) {
        try {
            this.lambdaObserver.onError(t);
        }
        finally {
            super.onError(t);
        }
    }

    @Override
    public void onComplete() {
        try {
            this.lambdaObserver.onComplete();
        }
        finally {
            super.onComplete();
        }
    }

    public void dispose() {
        this.lambdaObserver.dispose();
    }

    public boolean isDisposed() {
        return this.lambdaObserver.isDisposed();
    }

    private static void requireNonNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

