/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava;

import io.opentracing.Tracer;
import io.opentracing.rxjava.AbstractTracingSubscriber;
import rx.Observer;

public class TracingObserverSubscriber<T>
extends AbstractTracingSubscriber<T> {
    private final Observer<? super T> observer;

    public TracingObserverSubscriber(Observer<? super T> observer, String operationName, Tracer tracer) {
        super(operationName, tracer);
        if (observer == null) {
            throw new NullPointerException("observer is null");
        }
        this.observer = observer;
    }

    @Override
    public void onNext(T t) {
        this.observer.onNext(t);
    }

    @Override
    public void onError(Throwable e) {
        try {
            this.observer.onError(e);
        }
        finally {
            super.onError(e);
        }
    }

    @Override
    public void onCompleted() {
        try {
            this.observer.onCompleted();
        }
        finally {
            super.onCompleted();
        }
    }
}

