/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava;

import io.opentracing.ActiveSpan;
import io.opentracing.Tracer;
import io.opentracing.rxjava.TracingAction;
import io.opentracing.rxjava.TracingSubscriber;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.plugins.RxJavaHooks;

public class TracingRxJavaUtils {
    public static void enableTracing() {
        TracingRxJavaUtils.enableTracing(GlobalTracer.get());
    }

    public static void enableTracing(final Tracer tracer) {
        RxJavaHooks.setOnScheduleAction((Func1)new Func1<Action0, Action0>(){

            public Action0 call(Action0 action0) {
                return new TracingAction(action0, tracer);
            }
        });
        RxJavaHooks.setOnObservableStart((Func2)new Func2<Observable, Observable.OnSubscribe, Observable.OnSubscribe>(){

            public Observable.OnSubscribe call(Observable observable, final Observable.OnSubscribe onSubscribe) {
                return new Observable.OnSubscribe<Subscriber>(){

                    public void call(Subscriber subscriber) {
                        try (ActiveSpan activeSpan = tracer.buildSpan(onSubscribe.getClass().getSimpleName()).startActive();){
                            activeSpan.setTag(Tags.COMPONENT.getKey(), "rxjava-1");
                            TracingSubscriber t = new TracingSubscriber(subscriber, activeSpan);
                            subscriber.add((Subscription)t);
                            onSubscribe.call((Object)t);
                        }
                    }
                };
            }
        });
    }
}

