/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.apache.http.client;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.protocol.HttpContext;

public interface ApacheClientSpanDecorator {
    public void onRequest(HttpRequestWrapper var1, HttpContext var2, Span var3);

    public void onResponse(HttpResponse var1, HttpContext var2, Span var3);

    public void onError(HttpRequest var1, HttpContext var2, Exception var3, Span var4);

    public static class StandardTags
    implements ApacheClientSpanDecorator {
        private static final Logger log = Logger.getLogger(StandardTags.class.getName());

        @Override
        public void onRequest(HttpRequestWrapper request, HttpContext httpContext, Span span) {
            URI uri = request.getURI();
            HttpHost target = request.getTarget();
            Tags.HTTP_METHOD.set(span, request.getRequestLine().getMethod());
            if (uri != null) {
                String scheme;
                Tags.HTTP_URL.set(span, uri.toString());
                Tags.PEER_HOSTNAME.set(span, uri.getHost());
                int port = uri.getPort();
                if (port == -1 && (scheme = uri.getScheme()) != null) {
                    port = scheme.equalsIgnoreCase("https") ? 443 : 80;
                }
                Tags.PEER_PORT.set(span, Integer.valueOf(port));
            } else if (target != null) {
                Tags.HTTP_URL.set(span, request.getTarget() + request.getRequestLine().getUri());
                Tags.PEER_HOSTNAME.set(span, target.getHostName());
                Tags.PEER_PORT.set(span, Integer.valueOf(target.getPort() == -1 ? (target.getSchemeName().equalsIgnoreCase("https") ? 443 : 80) : target.getPort()));
            }
        }

        @Override
        public void onResponse(HttpResponse response, HttpContext httpContext, Span span) {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(response.getStatusLine().getStatusCode()));
        }

        @Override
        public void onError(HttpRequest request, HttpContext httpContext, Exception ex, Span span) {
            Tags.ERROR.set(span, Boolean.TRUE);
            HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
            errorLogs.put("event", Tags.ERROR.getKey());
            errorLogs.put("error.object", ex);
            span.log(errorLogs);
        }
    }
}

